"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegendListItem = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const legend_table_cell_1 = require("./legend_table_cell");
const legend_table_row_1 = require("./legend_table_row");
const legend_value_1 = require("./legend_value");
const common_1 = require("../../../utils/common");
const label_1 = require("../label");
const legend_color_picker_1 = require("../legend_color_picker");
const legend_item_1 = require("../legend_item");
const LegendListItem = (props) => {
    const { extraValues, item, legendValues, totalItems, action: Action, positionConfig, labelOptions, isMostlyRTL, onClick, toggleDeselectSeriesAction, onLegendItemMouseOver, onLegendItemMouseOut, hiddenItems, } = props;
    const { color, isSeriesHidden, isItemHidden, seriesIdentifiers, label, path, isToggleable } = item;
    const itemClassNames = (0, classnames_1.default)('echLegendTable__item', 'echLegendTable__item--highlightable', {
        'echLegendTable__item--hidden': isSeriesHidden,
        'echLegendTable__item--vertical': positionConfig.direction === common_1.LayoutDirection.Vertical,
    });
    const legendValueItems = (0, legend_item_1.prepareLegendValues)(item, legendValues, totalItems, extraValues);
    const onLabelToggle = (0, react_1.useCallback)((legendItemId) => (negate) => {
        if (totalItems <= 1 || (!isToggleable && !onClick)) {
            return;
        }
        if (onClick) {
            onClick(legendItemId);
        }
        if (isToggleable) {
            toggleDeselectSeriesAction(legendItemId, negate);
        }
    }, [onClick, toggleDeselectSeriesAction, isToggleable, totalItems]);
    const { renderItemColor, renderColorPickerPopup } = (0, legend_color_picker_1.useLegendColorPicker)(props);
    if (isItemHidden)
        return null;
    const ActionComponent = Action ? react_1.default.createElement(Action, { series: seriesIdentifiers, color: color, label: label }) : null;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(legend_table_row_1.LegendTableRow, { className: itemClassNames, onMouseEnter: () => onLegendItemMouseOver(seriesIdentifiers, path), onMouseLeave: onLegendItemMouseOut, dir: isMostlyRTL ? 'rtl' : 'ltr', "data-ech-series-name": label },
            react_1.default.createElement(legend_table_cell_1.LegendTableCell, { className: "echLegend__colorWrapper echLegendTable__colorCell" }, renderItemColor()),
            react_1.default.createElement(legend_table_cell_1.LegendTableCell, null,
                react_1.default.createElement(label_1.Label, { label: label, options: labelOptions, isToggleable: totalItems > 1 && item.isToggleable, onToggle: onLabelToggle(seriesIdentifiers), isSeriesHidden: isSeriesHidden, totalSeriesCount: totalItems, hiddenSeriesCount: hiddenItems })),
            legendValueItems.map((l, i) => {
                return react_1.default.createElement(legend_table_cell_1.LegendTableCell, { key: (l === null || l === void 0 ? void 0 : l.type) || i }, l && react_1.default.createElement(legend_value_1.LegendValueComponent, { ...l }));
            }),
            ActionComponent && (react_1.default.createElement(legend_table_cell_1.LegendTableCell, null,
                react_1.default.createElement("div", { className: "echLegendItem__action" }, ActionComponent)))),
        renderColorPickerPopup()));
};
exports.LegendListItem = LegendListItem;
//# sourceMappingURL=legend_table_item.js.map