"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageLoadingUI() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    style: {
      height: 'calc(100vh - 50px)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.pageLoadingTitle",
      defaultMessage: "Loading\u2026"
    })
  })));
}
const PageLoadingTracking = ({
  pageViewTitle
}) => {
  const path = pageViewTitle.toLowerCase().replace(/-/g, '').replace(/\s+/g, '_');
  (0, _public.useTrackPageview)({
    app: 'stack_monitoring',
    path
  });
  (0, _public.useTrackPageview)({
    app: 'stack_monitoring',
    path,
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(PageLoadingUI, null);
};
const PageLoading = ({
  pageViewTitle
}) => {
  if (pageViewTitle) {
    return /*#__PURE__*/_react.default.createElement(PageLoadingTracking, {
      pageViewTitle: pageViewTitle
    });
  }
  return /*#__PURE__*/_react.default.createElement(PageLoadingUI, null);
};
exports.PageLoading = PageLoading;