"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginStatement = PluginStatement;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _format_number = require("../../../../lib/format_number");
var _metric = require("./metric");
var _i18n = require("@kbn/i18n");
require("./plugin_statement.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInputStatementMetrics({
  latestEventsPerSecond
}) {
  return [/*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventsEmitted",
    className: "monPipelineViewer__metric--eventsEmitted",
    value: (0, _format_number.formatMetric)(latestEventsPerSecond, '0.[00]a', 'e/s emitted')
  })];
}
function getProcessorStatementMetrics(processorVertex) {
  const {
    latestMillisPerEvent,
    latestEventsPerSecond,
    percentOfTotalProcessorTime
  } = processorVertex;
  return [/*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "cpuMetric",
    className: "monPipelineViewer__metric--cpuTime",
    warning: processorVertex.isTimeConsuming(),
    value: (0, _format_number.formatMetric)(Math.round(percentOfTotalProcessorTime || 0), '0', '%', {
      prependSpace: false
    })
  }), /*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventMillis",
    className: "monPipelineViewer__metric--eventMillis",
    warning: processorVertex.isSlow(),
    value: (0, _format_number.formatMetric)(latestMillisPerEvent, '0.[00]a', 'ms/e')
  }), /*#__PURE__*/_react.default.createElement(_metric.Metric, {
    key: "eventsReceived",
    className: "monPipelineViewer__metric--events",
    value: (0, _format_number.formatMetric)(latestEventsPerSecond, '0.[00]a', 'e/s received')
  })];
}
function renderPluginStatementMetrics(pluginType, vertex) {
  return pluginType === 'input' ? getInputStatementMetrics(vertex) : getProcessorStatementMetrics(vertex);
}
function PluginStatement({
  statement: {
    hasExplicitId,
    id,
    name,
    pluginType,
    vertex
  },
  onShowVertexDetails
}) {
  const statementMetrics = renderPluginStatementMetrics(pluginType, vertex);
  const onNameButtonClick = () => {
    onShowVertexDetails(vertex);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: "monPipelineViewer__pluginStatement",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": name,
    className: "monPipelineViewer__plugin",
    color: "primary",
    flush: "left",
    iconType: "dot",
    onClick: onNameButtonClick,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, name))), hasExplicitId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: onNameButtonClick,
    onClickAriaLabel: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineStatement.viewDetailsAriaLabel', {
      defaultMessage: 'View details'
    })
  }, id)))), statementMetrics && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, statementMetrics)));
}
PluginStatement.propTypes = {
  onShowVertexDetails: _propTypes.default.func.isRequired,
  statement: _propTypes.default.shape({
    hasExplicitId: _propTypes.default.bool.isRequired,
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    pluginType: _propTypes.default.string.isRequired,
    vertex: _propTypes.default.shape({
      latestEventsPerSecond: _propTypes.default.number.isRequired,
      latestMillisPerEvent: _propTypes.default.number,
      percentOfTotalProcessorTime: _propTypes.default.number
    }).isRequired
  }).isRequired
};