"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reason = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../legacy_shims");
var _monospace = require("../metricbeat_migration/instruction_steps/components/monospace/monospace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Reason = ({
  reason
}) => {
  const filebeatUrl = _legacy_shims.Legacy.shims.docLinks.links.filebeat.installation;
  const elasticsearchUrl = _legacy_shims.Legacy.shims.docLinks.links.filebeat.elasticsearchModule;
  const troubleshootUrl = _legacy_shims.Legacy.shims.docLinks.links.monitoring.troubleshootKibana;
  let title = _i18n.i18n.translate('xpack.monitoring.logs.reason.defaultTitle', {
    defaultMessage: 'No log data found'
  });
  let message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logs.reason.defaultMessage",
    defaultMessage: "We did not find any log data and we are unable to diagnose why. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: filebeatUrl
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.logs.reason.defaultMessageLink",
        defaultMessage: "Please verify your setup is correct."
      }))
    }
  });
  if (false === reason.indexPatternExists) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternTitle', {
      defaultMessage: 'No log data found'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexPatternMessage",
      defaultMessage: "Set up {link}, then configure your Elasticsearch output to your monitoring cluster.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: filebeatUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternLink', {
          defaultMessage: 'Filebeat'
        }))
      }
    });
  } else if (false === reason.indexPatternInTimeRangeExists || false === reason.typeExists && reason.typeExistsAtAnyTime) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternInTimePeriodTitle', {
      defaultMessage: 'No logs for the selected time'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexPatternInTimePeriodMessage",
      defaultMessage: "Use the time filter to adjust your timeframe."
    });
  } else if (false === reason.typeExists) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noTypeTitle', {
      defaultMessage: 'No logs for Elasticsearch'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noTypeMessage",
      defaultMessage: "Follow {link} to set up Elasticsearch.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noTypeLink', {
          defaultMessage: 'these directions'
        }))
      }
    });
  } else if (false === reason.usingStructuredLogs) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.notUsingStructuredLogsTitle', {
      defaultMessage: 'No structured logs found'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.notUsingStructuredLogsMessage",
      defaultMessage: "Check if the {varPaths} setting {link}.",
      values: {
        varPaths: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, null, "var.paths"),
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.notUsingStructuredLogsLink', {
          defaultMessage: 'points to JSON logs'
        }))
      }
    });
  } else if (false === reason.clusterExists) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noClusterTitle', {
      defaultMessage: 'No logs for this cluster'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noClusterMessage",
      defaultMessage: "Check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noClusterLink', {
          defaultMessage: 'setup'
        }))
      }
    });
  } else if (false === reason.nodeExists) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noNodeTitle', {
      defaultMessage: 'No logs for this Elasticsearch node'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noNodeMessage",
      defaultMessage: "Check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noNodeLink', {
          defaultMessage: 'setup'
        }))
      }
    });
  } else if (false === reason.indexExists) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexTitle', {
      defaultMessage: 'No logs for this index'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexMessage",
      defaultMessage: "We found logs, but none for this index. If this problem continues, check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexLink', {
          defaultMessage: 'setup'
        }))
      }
    });
  } else if (false === reason.correctIndexName) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.correctIndexNameTitle', {
      defaultMessage: 'Corrupted filebeat index'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.correctIndexNameMessage",
      defaultMessage: "There is an issue reading from your filebeat indices.  {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: troubleshootUrl
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.correctIndexNameLink', {
          defaultMessage: 'Click here for more information'
        }))
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, message));
};
exports.Reason = Reason;