"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monacoPositionToOffset = monacoPositionToOffset;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// From Monaco position to linear offset
function monacoPositionToOffset(expression, position) {
  const lines = expression.split(/\n/);
  return lines.slice(0, position.lineNumber).reduce((prev, current, index) => prev + (index === position.lineNumber - 1 ? position.column - 1 : current.length + 1), 0);
}