"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHoverItem = getHoverItem;
var _i18n = require("@kbn/i18n");
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _utils = require("../shared/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function getHoverItem(model, position, token, astProvider, resourceRetriever) {
  const innerText = model.getValue();
  const offset = (0, _utils.monacoPositionToOffset)(innerText, position);
  const {
    ast
  } = await astProvider(innerText);
  const astContext = (0, _esqlValidationAutocomplete.getAstContext)(innerText, ast, offset);
  const {
    getPolicyMetadata
  } = (0, _esqlValidationAutocomplete.getPolicyHelper)(resourceRetriever);
  if (['newCommand', 'list'].includes(astContext.type)) {
    return {
      contents: []
    };
  }
  if (astContext.type === 'function') {
    const fnDefinition = (0, _esqlValidationAutocomplete.getFunctionDefinition)(astContext.node.name);
    if (fnDefinition) {
      return {
        contents: [{
          value: (0, _esqlValidationAutocomplete.getFunctionSignatures)(fnDefinition)[0].declaration
        }, {
          value: fnDefinition.description
        }]
      };
    }
  }
  if (astContext.type === 'expression') {
    if (astContext.node) {
      if ((0, _esqlValidationAutocomplete.isSourceItem)(astContext.node) && astContext.node.sourceType === 'policy') {
        const policyMetadata = await getPolicyMetadata(astContext.node.name);
        if (policyMetadata) {
          return {
            contents: [{
              value: `${_i18n.i18n.translate('monaco.esql.hover.policyIndexes', {
                defaultMessage: '**Indexes**'
              })}: ${policyMetadata.sourceIndices.join(', ')}`
            }, {
              value: `${_i18n.i18n.translate('monaco.esql.hover.policyMatchingField', {
                defaultMessage: '**Matching field**'
              })}: ${policyMetadata.matchField}`
            }, {
              value: `${_i18n.i18n.translate('monaco.esql.hover.policyEnrichedFields', {
                defaultMessage: '**Fields**'
              })}: ${policyMetadata.enrichFields.join(', ')}`
            }]
          };
        }
      }
      if ((0, _esqlValidationAutocomplete.isSettingItem)(astContext.node)) {
        const commandDef = (0, _esqlValidationAutocomplete.getCommandDefinition)(astContext.command.name);
        const settingDef = commandDef === null || commandDef === void 0 ? void 0 : commandDef.modes.find(({
          values
        }) => values.some(({
          name
        }) => name === astContext.node.name));
        if (settingDef) {
          const mode = settingDef.values.find(({
            name
          }) => name === astContext.node.name);
          return {
            contents: [{
              value: settingDef.description
            }, {
              value: `**${mode.name}**: ${mode.description}`
            }]
          };
        }
      }
    }
  }
  return {
    contents: []
  };
}