"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLTokensProvider = void 0;
var _antlr = require("antlr4");
var _esqlAst = require("@kbn/esql-ast");
var _esql_token = require("./esql_token");
var _esql_line_tokens = require("./esql_line_tokens");
var _esql_state = require("./esql_state");
var _constants = require("./constants");
var _esql_token_helpers = require("./esql_token_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EOF = -1;
class ESQLTokensProvider {
  getInitialState() {
    return new _esql_state.ESQLState();
  }
  tokenize(line, prevState) {
    const errorStartingPoints = [];
    const errorListener = new _esqlAst.ESQLErrorListener();
    // This has the drawback of not styling any ESQL wrong query as
    // | from ...
    const cleanedLine = prevState.getLineNumber() && line.trimStart()[0] === '|' ? line.trimStart().substring(1) : line;
    const inputStream = _antlr.CharStreams.fromString(cleanedLine);
    const lexer = (0, _esqlAst.getLexer)(inputStream, errorListener);
    let done = false;
    const myTokens = [];
    do {
      let token;
      try {
        token = lexer.nextToken();
      } catch (e) {
        token = null;
      }
      if (token == null) {
        done = true;
      } else {
        if (token.type === EOF) {
          done = true;
        } else {
          const tokenTypeName = lexer.symbolicNames[token.type];
          if (tokenTypeName) {
            const indexOffset = cleanedLine === line ? 0 : line.length - cleanedLine.length;
            const myToken = new _esql_token.ESQLToken(tokenTypeName, token.start + indexOffset, token.stop + indexOffset);
            myTokens.push(myToken);
          }
        }
      }
    } while (!done);
    for (const e of errorStartingPoints) {
      myTokens.push(new _esql_token.ESQLToken('error' + _constants.ESQL_TOKEN_POSTFIX, e));
    }
    myTokens.sort((a, b) => a.startIndex - b.startIndex);

    // special treatment for functions
    // the previous custom Kibana grammar baked functions directly as tokens, so highlight was easier
    // The ES grammar doesn't have the token concept of "function"
    const tokensWithFunctions = (0, _esql_token_helpers.addFunctionTokens)(myTokens);
    (0, _esql_token_helpers.addNullsOrder)(tokensWithFunctions);
    return new _esql_line_tokens.ESQLLineTokens(tokensWithFunctions, prevState.getLineNumber() + 1);
  }
}
exports.ESQLTokensProvider = ESQLTokensProvider;