"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFunctionTokens = addFunctionTokens;
exports.addNullsOrder = addNullsOrder;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function nonNullable(value) {
  return value != null;
}
function addFunctionTokens(tokens) {
  // need to trim spaces as "abs (arg)" is still valid as function
  const myTokensWithoutSpaces = tokens.filter(({
    scopes
  }) => scopes !== 'expr_ws' + _constants.ESQL_TOKEN_POSTFIX);
  // find out all unquoted_identifiers index
  const possiblyFunctions = myTokensWithoutSpaces.map((t, i) => t.scopes === 'unquoted_identifier' + _constants.ESQL_TOKEN_POSTFIX ? i : undefined).filter(nonNullable);

  // then check if the token next is an opening bracket
  for (const index of possiblyFunctions) {
    var _myTokensWithoutSpace;
    if (((_myTokensWithoutSpace = myTokensWithoutSpaces[index + 1]) === null || _myTokensWithoutSpace === void 0 ? void 0 : _myTokensWithoutSpace.scopes) === 'lp' + _constants.ESQL_TOKEN_POSTFIX) {
      // set the custom "functions" token (only used in theming)
      myTokensWithoutSpaces[index].scopes = 'functions' + _constants.ESQL_TOKEN_POSTFIX;
    }
  }
  return [...tokens];
}
function addNullsOrder(tokens) {
  var _tokens;
  const nullsIndex = tokens.findIndex(token => token.scopes === 'nulls' + _constants.ESQL_TOKEN_POSTFIX);
  if (
  // did we find a "nulls"?
  nullsIndex > -1 &&
  // is the next non-whitespace token an order?
  ['first' + _constants.ESQL_TOKEN_POSTFIX, 'last' + _constants.ESQL_TOKEN_POSTFIX].includes((_tokens = tokens[nullsIndex + 2]) === null || _tokens === void 0 ? void 0 : _tokens.scopes)) {
    tokens[nullsIndex].scopes = 'nulls_order' + _constants.ESQL_TOKEN_POSTFIX;
    tokens.splice(nullsIndex + 1, 2);
  }
}