"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildESQlTheme = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _theme = require("../../common/theme");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)(_constants.ESQL_TOKEN_POSTFIX);
const buildESQlTheme = () => ({
  base: _uiTheme.darkMode ? 'vs-dark' : 'vs',
  inherit: true,
  rules: [
  // base
  ...buildRuleGroup(['explain', 'row', 'limit', 'ws', 'assign', 'comma', 'dot', 'first', 'last', 'opening_bracket', 'closing_bracket', 'quoted_identifier', 'src_ws', 'unquoted_identifier', 'pipe', 'not', 'percent', 'integer_literal', 'decimal_literal', 'src_unquoted_identifier', 'src_quoted_identifier', 'string'], _uiTheme.euiThemeVars.euiTextColor),
  // source commands
  ...buildRuleGroup(['from', 'row', 'show'], _uiTheme.euiThemeVars.euiColorPrimaryText, true // isBold
  ),
  // commands
  ...buildRuleGroup(['metrics', 'metadata', 'mv_expand', 'stats', 'dissect', 'grok', 'project', 'keep', 'rename', 'drop', 'eval', 'sort', 'by', 'where', 'not', 'is', 'like', 'rlike', 'in', 'as', 'expr_ws', 'limit', 'null', 'enrich', 'on', 'with', 'asc', 'desc', 'nulls_order'], _uiTheme.euiThemeVars.euiColorAccentText, true // isBold
  ),
  // functions
  ...buildRuleGroup(['functions'], _uiTheme.euiThemeVars.euiColorPrimaryText),
  // operators
  ...buildRuleGroup(['or', 'and', 'rp',
  // ')'
  'lp',
  // '('
  'eq',
  // '=='
  'cieq',
  // '=~'
  'neq',
  // '!='
  'lt',
  //  '<'
  'lte',
  // '<='
  'gt',
  //  '>'
  'gte',
  // '>='
  'plus',
  // '+'
  'minus',
  // '-'
  'asterisk',
  // '*'
  'slash',
  // '/'
  'percent' // '%'
  ], _uiTheme.euiThemeVars.euiColorPrimaryText),
  // comments
  ...buildRuleGroup(['line_comment', 'multiline_comment', 'expr_line_comment', 'expr_multiline_comment', 'src_line_comment', 'src_multiline_comment'], _uiTheme.euiThemeVars.euiColorDisabledText),
  // values
  ...buildRuleGroup(['quoted_string', 'integer_literal', 'decimal_literal'], _uiTheme.euiThemeVars.euiColorSuccessText)],
  colors: {
    'editor.foreground': _uiTheme.euiThemeVars.euiTextColor,
    'editor.background': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editor.lineHighlightBackground': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.lineHighlightBorder': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.selectionHighlightBackground': _uiTheme.euiThemeVars.euiColorLightestShade,
    'editor.selectionHighlightBorder': _uiTheme.euiThemeVars.euiColorLightShade,
    'editorSuggestWidget.background': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.border': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.focusHighlightForeground': _uiTheme.euiThemeVars.euiColorEmptyShade,
    'editorSuggestWidget.foreground': _uiTheme.euiThemeVars.euiTextColor,
    'editorSuggestWidget.highlightForeground': _uiTheme.euiThemeVars.euiColorPrimary,
    'editorSuggestWidget.selectedBackground': _uiTheme.euiThemeVars.euiColorPrimary,
    'editorSuggestWidget.selectedForeground': _uiTheme.euiThemeVars.euiColorEmptyShade
  }
});
exports.buildESQlTheme = buildESQlTheme;