"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapAsMonacoCodeActions = wrapAsMonacoCodeActions;
var _positions = require("./positions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function wrapAsMonacoCodeActions(model, actions) {
  const queryString = model.getValue();
  const uri = model.uri;
  return actions.map(action => {
    const [error] = (0, _positions.wrapAsMonacoMessages)(queryString, action.diagnostics);
    return {
      title: action.title,
      diagnostics: [error],
      kind: action.kind,
      edit: {
        edits: action.edits.map(edit => {
          return {
            resource: uri,
            textEdit: {
              range: error,
              text: edit.text
            },
            versionId: undefined
          };
        })
      }
    };
  });
}