"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.consoleOutputLexerRules = exports.consoleOutputLanguageConfiguration = void 0;
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const consoleOutputLanguageConfiguration = exports.consoleOutputLanguageConfiguration = {
  ..._shared.consoleSharedLanguageConfiguration
};
const consoleOutputLexerRules = exports.consoleOutputLexerRules = {
  ..._shared.consoleSharedLexerRules,
  tokenizer: {
    ..._shared.consoleSharedLexerRules.tokenizer,
    comments: [
    // Line comment indicated by #
    // Everything after the # character is matched, stopping right before the status code and status text at the end if they are present
    (0, _shared.matchTokensWithEOL)('comment', /# .+?(?=\s+\d{3}(?: \w+)*$)/, 'root', 'status'), ..._shared.consoleSharedLexerRules.tokenizer.comments],
    status: [
    // Following HTTP response status codes conventions
    // Informational responses (status codes 100 – 199)
    (0, _shared.matchTokensWithEOL)('status.info', /\b1\d{2}(?: \w+)*$/, 'root'),
    // Successful responses (status codes 200 – 299)
    (0, _shared.matchTokensWithEOL)('status.success', /\b2\d{2}(?: \w+)*$/, 'root'),
    // Redirection messages (status codes 300 – 399)
    (0, _shared.matchTokensWithEOL)('status.redirect', /\b3\d{2}(?: \w+)*$/, 'root'),
    // Client and server error responses (status codes 400 – 599)
    (0, _shared.matchTokensWithEOL)('status.error', /\b[4-5]\d{2}(?: \w+)*$/, 'root')]
  }
};