"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParsedRequestsProvider = void 0;
var _console_errors_provider = require("./console_errors_provider");
var _console_worker_proxy = require("./console_worker_proxy");
var _monaco_imports = require("../monaco_imports");
var _constants = require("./constants");
var _console_parsed_requests_provider = require("./console_parsed_requests_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const workerProxyService = new _console_worker_proxy.ConsoleWorkerProxyService();
const getParsedRequestsProvider = model => {
  return new _console_parsed_requests_provider.ConsoleParsedRequestsProvider(workerProxyService, model);
};
exports.getParsedRequestsProvider = getParsedRequestsProvider;
_monaco_imports.monaco.languages.onLanguage(_constants.CONSOLE_LANG_ID, async () => {
  workerProxyService.setup();
  (0, _console_errors_provider.setupConsoleErrorsProvider)(workerProxyService);
});