/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.ml_bundle_jsonpfunction=window.ml_bundle_jsonpfunction||[]).push([[83],{787:function(e){e.exports=JSON.parse('{"type":"object","properties":{"allow_lazy_start":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/ml-settings.html"},"description":"Specifies whether this job can start when there is insufficient machine\\nlearning node capacity for it to be immediately assigned to a node. If\\nset to `false` and a machine learning node with capacity to run the job\\ncannot be immediately found, the API returns an error. If set to `true`,\\nthe API does not return an error; the job waits in the `starting` state\\nuntil sufficient machine learning node capacity is available. This\\nbehavior is also affected by the cluster-wide\\n`xpack.ml.max_lazy_ml_nodes` setting.","type":"boolean"},"analysis":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisContainer"},"analyzed_fields":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisAnalyzedFields"},"description":{"description":"A description of the job.","type":"string"},"dest":{"$ref":"#/components/schemas/ml._types:DataframeAnalyticsDestination"},"max_num_threads":{"description":"The maximum number of threads to be used by the analysis. Using more\\nthreads may decrease the time necessary to complete the analysis at the\\ncost of using more CPU. Note that the process may use additional threads\\nfor operational functionality other than the analysis itself.","type":"number"},"model_memory_limit":{"description":"The approximate maximum amount of memory resources that are permitted for\\nanalytical processing. If your `elasticsearch.yml` file contains an\\n`xpack.ml.max_model_memory_limit` setting, an error occurs when you try\\nto create data frame analytics jobs that have `model_memory_limit` values\\ngreater than that setting.","type":"string"},"source":{"$ref":"#/components/schemas/ml._types:DataframeAnalyticsSource"},"headers":{"$ref":"#/components/schemas/_types:HttpHeaders"},"version":{"$ref":"#/components/schemas/_types:VersionString"}},"required":["analysis","dest","source"],"components":{"schemas":{"ml._types:DataframeAnalysisContainer":{"type":"object","properties":{"classification":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisClassification"},"outlier_detection":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisOutlierDetection"},"regression":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisRegression"}},"minProperties":1,"maxProperties":1},"ml._types:DataframeAnalysisClassification":{"allOf":[{"$ref":"#/components/schemas/ml._types:DataframeAnalysis"},{"type":"object","properties":{"class_assignment_objective":{"type":"string"},"num_top_classes":{"description":"Defines the number of categories for which the predicted probabilities are reported. It must be non-negative or -1. If it is -1 or greater than the total number of categories, probabilities are reported for all categories; if you have a large number of categories, there could be a significant effect on the size of your destination index. NOTE: To use the AUC ROC evaluation method, `num_top_classes` must be set to -1 or a value greater than or equal to the total number of categories.","type":"number"}}}]},"ml._types:DataframeAnalysis":{"type":"object","properties":{"alpha":{"description":"Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This parameter affects loss calculations by acting as a multiplier of the tree depth. Higher alpha values result in shallower trees and faster training times. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to zero.","type":"number"},"dependent_variable":{"description":"Defines which field of the document is to be predicted. It must match one of the fields in the index being used to train. If this field is missing from a document, then that document will not be used for training, but a prediction with the trained model will be generated for it. It is also known as continuous target variable.\\nFor classification analysis, the data type of the field must be numeric (`integer`, `short`, `long`, `byte`), categorical (`ip` or `keyword`), or `boolean`. There must be no more than 30 different values in this field.\\nFor regression analysis, the data type of the field must be numeric.","type":"string"},"downsample_factor":{"description":"Advanced configuration option. Controls the fraction of data that is used to compute the derivatives of the loss function for tree training. A small value results in the use of a small fraction of the data. If this value is set to be less than 1, accuracy typically improves. However, too small a value may result in poor convergence for the ensemble and so require more trees. By default, this value is calculated during hyperparameter optimization. It must be greater than zero and less than or equal to 1.","type":"number"},"early_stopping_enabled":{"description":"Advanced configuration option. Specifies whether the training process should finish if it is not finding any better performing models. If disabled, the training process can take significantly longer and the chance of finding a better performing model is unremarkable.","type":"boolean"},"eta":{"description":"Advanced configuration option. The shrinkage applied to the weights. Smaller values result in larger forests which have a better generalization error. However, larger forests cause slower training. By default, this value is calculated during hyperparameter optimization. It must be a value between 0.001 and 1.","type":"number"},"eta_growth_rate_per_tree":{"description":"Advanced configuration option. Specifies the rate at which `eta` increases for each new tree that is added to the forest. For example, a rate of 1.05 increases `eta` by 5% for each extra tree. By default, this value is calculated during hyperparameter optimization. It must be between 0.5 and 2.","type":"number"},"feature_bag_fraction":{"description":"Advanced configuration option. Defines the fraction of features that will be used when selecting a random bag for each candidate split. By default, this value is calculated during hyperparameter optimization.","type":"number"},"feature_processors":{"description":"Advanced configuration option. A collection of feature preprocessors that modify one or more included fields. The analysis uses the resulting one or more features instead of the original document field. However, these features are ephemeral; they are not stored in the destination index. Multiple `feature_processors` entries can refer to the same document fields. Automatic categorical feature encoding still occurs for the fields that are unprocessed by a custom processor or that have categorical values. Use this property only if you want to override the automatic feature encoding of the specified fields.","type":"array","items":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessor"}},"gamma":{"description":"Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies a linear penalty associated with the size of individual trees in the forest. A high gamma value causes training to prefer small trees. A small gamma value results in larger individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.","type":"number"},"lambda":{"description":"Advanced configuration option. Regularization parameter to prevent overfitting on the training data set. Multiplies an L2 regularization term which applies to leaf weights of the individual trees in the forest. A high lambda value causes training to favor small leaf weights. This behavior makes the prediction function smoother at the expense of potentially not being able to capture relevant relationships between the features and the dependent variable. A small lambda value results in large individual trees and slower training. By default, this value is calculated during hyperparameter optimization. It must be a nonnegative value.","type":"number"},"max_optimization_rounds_per_hyperparameter":{"description":"Advanced configuration option. A multiplier responsible for determining the maximum number of hyperparameter optimization steps in the Bayesian optimization procedure. The maximum number of steps is determined based on the number of undefined hyperparameters times the maximum optimization rounds per hyperparameter. By default, this value is calculated during hyperparameter optimization.","type":"number"},"max_trees":{"description":"Advanced configuration option. Defines the maximum number of decision trees in the forest. The maximum value is 2000. By default, this value is calculated during hyperparameter optimization.","type":"number"},"num_top_feature_importance_values":{"description":"Advanced configuration option. Specifies the maximum number of feature importance values per document to return. By default, no feature importance calculation occurs.","type":"number"},"prediction_field_name":{"$ref":"#/components/schemas/_types:Field"},"randomize_seed":{"description":"Defines the seed for the random generator that is used to pick training data. By default, it is randomly generated. Set it to a specific value to use the same training data each time you start a job (assuming other related parameters such as `source` and `analyzed_fields` are the same).","type":"number"},"soft_tree_depth_limit":{"description":"Advanced configuration option. Machine learning uses loss guided tree growing, which means that the decision trees grow where the regularized loss decreases most quickly. This soft limit combines with the `soft_tree_depth_tolerance` to penalize trees that exceed the specified depth; the regularized loss increases quickly beyond this depth. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.","type":"number"},"soft_tree_depth_tolerance":{"description":"Advanced configuration option. This option controls how quickly the regularized loss increases when the tree depth exceeds `soft_tree_depth_limit`. By default, this value is calculated during hyperparameter optimization. It must be greater than or equal to 0.01.","type":"number"},"training_percent":{"$ref":"#/components/schemas/_types:Percentage"}},"required":["dependent_variable"]},"ml._types:DataframeAnalysisFeatureProcessor":{"type":"object","properties":{"frequency_encoding":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessorFrequencyEncoding"},"multi_encoding":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessorMultiEncoding"},"n_gram_encoding":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessorNGramEncoding"},"one_hot_encoding":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessorOneHotEncoding"},"target_mean_encoding":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisFeatureProcessorTargetMeanEncoding"}},"minProperties":1,"maxProperties":1},"ml._types:DataframeAnalysisFeatureProcessorFrequencyEncoding":{"type":"object","properties":{"feature_name":{"$ref":"#/components/schemas/_types:Name"},"field":{"$ref":"#/components/schemas/_types:Field"},"frequency_map":{"description":"The resulting frequency map for the field value. If the field value is missing from the frequency_map, the resulting value is 0.","type":"object","additionalProperties":{"type":"number"}}},"required":["feature_name","field","frequency_map"]},"_types:Name":{"type":"string"},"_types:Field":{"description":"Path to field or array of paths. Some API\'s support wildcards in the path to select multiple fields.","type":"string"},"ml._types:DataframeAnalysisFeatureProcessorMultiEncoding":{"type":"object","properties":{"processors":{"description":"The ordered array of custom processors to execute. Must be more than 1.","type":"array","items":{"type":"number"}}},"required":["processors"]},"ml._types:DataframeAnalysisFeatureProcessorNGramEncoding":{"type":"object","properties":{"feature_prefix":{"description":"The feature name prefix. Defaults to ngram_<start>_<length>.","type":"string"},"field":{"$ref":"#/components/schemas/_types:Field"},"length":{"description":"Specifies the length of the n-gram substring. Defaults to 50. Must be greater than 0.","type":"number"},"n_grams":{"description":"Specifies which n-grams to gather. It’s an array of integer values where the minimum value is 1, and a maximum value is 5.","type":"array","items":{"type":"number"}},"start":{"description":"Specifies the zero-indexed start of the n-gram substring. Negative values are allowed for encoding n-grams of string suffixes. Defaults to 0.","type":"number"},"custom":{"type":"boolean"}},"required":["field","n_grams"]},"ml._types:DataframeAnalysisFeatureProcessorOneHotEncoding":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"hot_map":{"description":"The one hot map mapping the field value with the column name.","type":"string"}},"required":["field","hot_map"]},"ml._types:DataframeAnalysisFeatureProcessorTargetMeanEncoding":{"type":"object","properties":{"default_value":{"description":"The default value if field value is not found in the target_map.","type":"number"},"feature_name":{"$ref":"#/components/schemas/_types:Name"},"field":{"$ref":"#/components/schemas/_types:Field"},"target_map":{"description":"The field value to target mean transition map.","type":"object","additionalProperties":{"type":"object"}}},"required":["default_value","feature_name","field","target_map"]},"_types:Percentage":{"oneOf":[{"type":"string"},{"type":"number"}]},"ml._types:DataframeAnalysisOutlierDetection":{"type":"object","properties":{"compute_feature_influence":{"description":"Specifies whether the feature influence calculation is enabled.","type":"boolean"},"feature_influence_threshold":{"description":"The minimum outlier score that a document needs to have in order to calculate its feature influence score. Value range: 0-1.","type":"number"},"method":{"description":"The method that outlier detection uses. Available methods are `lof`, `ldof`, `distance_kth_nn`, `distance_knn`, and `ensemble`. The default value is ensemble, which means that outlier detection uses an ensemble of different methods and normalises and combines their individual outlier scores to obtain the overall outlier score.","type":"string"},"n_neighbors":{"description":"Defines the value for how many nearest neighbors each method of outlier detection uses to calculate its outlier score. When the value is not set, different values are used for different ensemble members. This default behavior helps improve the diversity in the ensemble; only override it if you are confident that the value you choose is appropriate for the data set.","type":"number"},"outlier_fraction":{"description":"The proportion of the data set that is assumed to be outlying prior to outlier detection. For example, 0.05 means it is assumed that 5% of values are real outliers and 95% are inliers.","type":"number"},"standardization_enabled":{"description":"If true, the following operation is performed on the columns before computing outlier scores: `(x_i - mean(x_i)) / sd(x_i)`.","type":"boolean"}}},"ml._types:DataframeAnalysisRegression":{"allOf":[{"$ref":"#/components/schemas/ml._types:DataframeAnalysis"},{"type":"object","properties":{"loss_function":{"description":"The loss function used during regression. Available options are `mse` (mean squared error), `msle` (mean squared logarithmic error), `huber` (Pseudo-Huber loss).","type":"string"},"loss_function_parameter":{"description":"A positive number that is used as a parameter to the `loss_function`.","type":"number"}}}]},"ml._types:DataframeAnalysisAnalyzedFields":{"type":"object","properties":{"includes":{"description":"An array of strings that defines the fields that will be excluded from the analysis. You do not need to add fields with unsupported data types to excludes, these fields are excluded from the analysis automatically.","type":"array","items":{"type":"string"}},"excludes":{"description":"An array of strings that defines the fields that will be included in the analysis.","type":"array","items":{"type":"string"}}},"required":["includes","excludes"]},"ml._types:DataframeAnalyticsDestination":{"type":"object","properties":{"index":{"$ref":"#/components/schemas/_types:IndexName"},"results_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["index"]},"_types:IndexName":{"type":"string"},"ml._types:DataframeAnalyticsSource":{"type":"object","properties":{"index":{"$ref":"#/components/schemas/_types:Indices"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"runtime_mappings":{"$ref":"#/components/schemas/_types.mapping:RuntimeFields"},"_source":{"$ref":"#/components/schemas/ml._types:DataframeAnalysisAnalyzedFields"}},"required":["index"]},"_types:Indices":{"oneOf":[{"$ref":"#/components/schemas/_types:IndexName"},{"type":"array","items":{"$ref":"#/components/schemas/_types:IndexName"}}]},"_types.query_dsl:QueryContainer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html"},"type":"object","properties":{"bool":{"$ref":"#/components/schemas/_types.query_dsl:BoolQuery"},"boosting":{"$ref":"#/components/schemas/_types.query_dsl:BoostingQuery"},"common":{"deprecated":true,"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:CommonTermsQuery"},"minProperties":1,"maxProperties":1},"combined_fields":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsQuery"},"constant_score":{"$ref":"#/components/schemas/_types.query_dsl:ConstantScoreQuery"},"dis_max":{"$ref":"#/components/schemas/_types.query_dsl:DisMaxQuery"},"distance_feature":{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQuery"},"exists":{"$ref":"#/components/schemas/_types.query_dsl:ExistsQuery"},"function_score":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreQuery"},"fuzzy":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-fuzzy-query.html"},"description":"Returns documents that contain terms similar to the search term, as measured by a Levenshtein edit distance.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:FuzzyQuery"},"minProperties":1,"maxProperties":1},"geo_bounding_box":{"$ref":"#/components/schemas/_types.query_dsl:GeoBoundingBoxQuery"},"geo_distance":{"$ref":"#/components/schemas/_types.query_dsl:GeoDistanceQuery"},"geo_polygon":{"$ref":"#/components/schemas/_types.query_dsl:GeoPolygonQuery"},"geo_shape":{"$ref":"#/components/schemas/_types.query_dsl:GeoShapeQuery"},"has_child":{"$ref":"#/components/schemas/_types.query_dsl:HasChildQuery"},"has_parent":{"$ref":"#/components/schemas/_types.query_dsl:HasParentQuery"},"ids":{"$ref":"#/components/schemas/_types.query_dsl:IdsQuery"},"intervals":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-intervals-query.html"},"description":"Returns documents based on the order and proximity of matching terms.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsQuery"},"minProperties":1,"maxProperties":1},"knn":{"$ref":"#/components/schemas/_types:KnnQuery"},"match":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query.html"},"description":"Returns documents that match a provided text, number, date or boolean value.\\nThe provided text is analyzed before matching.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchQuery"},"minProperties":1,"maxProperties":1},"match_all":{"$ref":"#/components/schemas/_types.query_dsl:MatchAllQuery"},"match_bool_prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-bool-prefix-query.html"},"description":"Analyzes its input and constructs a `bool` query from the terms.\\nEach term except the last is used in a `term` query.\\nThe last term is used in a prefix query.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchBoolPrefixQuery"},"minProperties":1,"maxProperties":1},"match_none":{"$ref":"#/components/schemas/_types.query_dsl:MatchNoneQuery"},"match_phrase":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query-phrase.html"},"description":"Analyzes the text and creates a phrase query out of the analyzed text.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchPhraseQuery"},"minProperties":1,"maxProperties":1},"match_phrase_prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-match-query-phrase-prefix.html"},"description":"Returns documents that contain the words of a provided text, in the same order as provided.\\nThe last term of the provided text is treated as a prefix, matching any words that begin with that term.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:MatchPhrasePrefixQuery"},"minProperties":1,"maxProperties":1},"more_like_this":{"$ref":"#/components/schemas/_types.query_dsl:MoreLikeThisQuery"},"multi_match":{"$ref":"#/components/schemas/_types.query_dsl:MultiMatchQuery"},"nested":{"$ref":"#/components/schemas/_types.query_dsl:NestedQuery"},"parent_id":{"$ref":"#/components/schemas/_types.query_dsl:ParentIdQuery"},"percolate":{"$ref":"#/components/schemas/_types.query_dsl:PercolateQuery"},"pinned":{"$ref":"#/components/schemas/_types.query_dsl:PinnedQuery"},"prefix":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-prefix-query.html"},"description":"Returns documents that contain a specific prefix in a provided field.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:PrefixQuery"},"minProperties":1,"maxProperties":1},"query_string":{"$ref":"#/components/schemas/_types.query_dsl:QueryStringQuery"},"range":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-range-query.html"},"description":"Returns documents that contain terms within a provided range.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:RangeQuery"},"minProperties":1,"maxProperties":1},"rank_feature":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureQuery"},"regexp":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-regexp-query.html"},"description":"Returns documents that contain terms matching a regular expression.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:RegexpQuery"},"minProperties":1,"maxProperties":1},"rule_query":{"$ref":"#/components/schemas/_types.query_dsl:RuleQuery"},"script":{"$ref":"#/components/schemas/_types.query_dsl:ScriptQuery"},"script_score":{"$ref":"#/components/schemas/_types.query_dsl:ScriptScoreQuery"},"shape":{"$ref":"#/components/schemas/_types.query_dsl:ShapeQuery"},"simple_query_string":{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringQuery"},"span_containing":{"$ref":"#/components/schemas/_types.query_dsl:SpanContainingQuery"},"field_masking_span":{"$ref":"#/components/schemas/_types.query_dsl:SpanFieldMaskingQuery"},"span_first":{"$ref":"#/components/schemas/_types.query_dsl:SpanFirstQuery"},"span_multi":{"$ref":"#/components/schemas/_types.query_dsl:SpanMultiTermQuery"},"span_near":{"$ref":"#/components/schemas/_types.query_dsl:SpanNearQuery"},"span_not":{"$ref":"#/components/schemas/_types.query_dsl:SpanNotQuery"},"span_or":{"$ref":"#/components/schemas/_types.query_dsl:SpanOrQuery"},"span_term":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-span-term-query.html"},"description":"Matches spans containing a term.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:SpanTermQuery"},"minProperties":1,"maxProperties":1},"span_within":{"$ref":"#/components/schemas/_types.query_dsl:SpanWithinQuery"},"term":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-term-query.html"},"description":"Returns documents that contain an exact term in a provided field.\\nTo return a document, the query term must exactly match the queried field\'s value, including whitespace and capitalization.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TermQuery"},"minProperties":1,"maxProperties":1},"terms":{"$ref":"#/components/schemas/_types.query_dsl:TermsQuery"},"terms_set":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-terms-set-query.html"},"description":"Returns documents that contain a minimum number of exact terms in a provided field.\\nTo return a document, a required number of terms must exactly match the field values, including whitespace and capitalization.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TermsSetQuery"},"minProperties":1,"maxProperties":1},"text_expansion":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-text-expansion-query.html"},"description":"Uses a natural language processing model to convert the query text into a list of token-weight pairs which are then used in a query against a sparse vector or rank features field.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:TextExpansionQuery"},"minProperties":1,"maxProperties":1},"weighted_tokens":{"description":"Supports returning text_expansion query results by sending in precomputed tokens with the query.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:WeightedTokensQuery"},"minProperties":1,"maxProperties":1},"wildcard":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-wildcard-query.html"},"description":"Returns documents that contain terms matching a wildcard pattern.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:WildcardQuery"},"minProperties":1,"maxProperties":1},"wrapper":{"$ref":"#/components/schemas/_types.query_dsl:WrapperQuery"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TypeQuery"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:BoolQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"filter":{"description":"The clause (query) must appear in matching documents.\\nHowever, unlike `must`, the score of the query will be ignored.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"must":{"description":"The clause (query) must appear in matching documents and will contribute to the score.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"must_not":{"description":"The clause (query) must not appear in the matching documents.\\nBecause scoring is ignored, a score of `0` is returned for all documents.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"should":{"description":"The clause (query) should appear in the matching document.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]}}}]},"_types.query_dsl:QueryBase":{"type":"object","properties":{"boost":{"description":"Floating point number used to decrease or increase the relevance scores of the query.\\nBoost values are relative to the default value of 1.0.\\nA boost value between 0 and 1.0 decreases the relevance score.\\nA value greater than 1.0 increases the relevance score.","type":"number"},"_name":{"type":"string"}}},"_types:MinimumShouldMatch":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-minimum-should-match.html"},"description":"The minimum number of terms that should match as integer, percentage or range","oneOf":[{"type":"number"},{"type":"string"}]},"_types.query_dsl:BoostingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"negative_boost":{"description":"Floating point number between 0 and 1.0 used to decrease the relevance scores of documents matching the `negative` query.","type":"number"},"negative":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"positive":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["negative_boost","negative","positive"]}]},"_types.query_dsl:CommonTermsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"type":"string"},"cutoff_frequency":{"type":"number"},"high_freq_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"low_freq_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"query":{"type":"string"}},"required":["query"]}]},"_types.query_dsl:Operator":{"type":"string","enum":["and","AND","or","OR"]},"_types.query_dsl:CombinedFieldsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"fields":{"description":"List of fields to search. Field wildcard patterns are allowed. Only `text` fields are supported, and they must all have the same search `analyzer`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"query":{"description":"Text to search for in the provided `fields`.\\nThe `combined_fields` query analyzes the provided text before performing a search.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If true, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsOperator"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:CombinedFieldsZeroTerms"}},"required":["fields","query"]}]},"_types.query_dsl:CombinedFieldsOperator":{"type":"string","enum":["or","and"]},"_types.query_dsl:CombinedFieldsZeroTerms":{"type":"string","enum":["none","all"]},"_types.query_dsl:ConstantScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["filter"]}]},"_types.query_dsl:DisMaxQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"queries":{"description":"One or more query clauses.\\nReturned documents must match one or more of these queries.\\nIf a document matches multiple queries, Elasticsearch uses the highest relevance score.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"tie_breaker":{"description":"Floating point number between 0 and 1.0 used to increase the relevance scores of documents matching multiple query clauses.","type":"number"}},"required":["queries"]}]},"_types.query_dsl:DistanceFeatureQuery":{"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:GeoDistanceFeatureQuery"},{"$ref":"#/components/schemas/_types.query_dsl:DateDistanceFeatureQuery"}]},"_types.query_dsl:GeoDistanceFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQueryBaseGeoLocationDistance"},{"type":"object"}]},"_types.query_dsl:DistanceFeatureQueryBaseGeoLocationDistance":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"origin":{"$ref":"#/components/schemas/_types:GeoLocation"},"pivot":{"$ref":"#/components/schemas/_types:Distance"},"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["origin","pivot","field"]}]},"_types:GeoLocation":{"description":"A latitude/longitude as a 2 dimensional point. It can be represented in various ways:\\n- as a `{lat, long}` object\\n- as a geo hash value\\n- as a `[lon, lat]` array\\n- as a string in `\\"<lat>, <lon>\\"` or WKT point formats","oneOf":[{"$ref":"#/components/schemas/_types:LatLonGeoLocation"},{"$ref":"#/components/schemas/_types:GeoHashLocation"},{"type":"array","items":{"type":"number"}},{"type":"string"}]},"_types:LatLonGeoLocation":{"type":"object","properties":{"lat":{"description":"Latitude","type":"number"},"lon":{"description":"Longitude","type":"number"}},"required":["lat","lon"]},"_types:GeoHashLocation":{"type":"object","properties":{"geohash":{"$ref":"#/components/schemas/_types:GeoHash"}},"required":["geohash"]},"_types:GeoHash":{"type":"string"},"_types:Distance":{"type":"string"},"_types.query_dsl:DateDistanceFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DistanceFeatureQueryBaseDateMathDuration"},{"type":"object"}]},"_types.query_dsl:DistanceFeatureQueryBaseDateMathDuration":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"origin":{"$ref":"#/components/schemas/_types:DateMath"},"pivot":{"$ref":"#/components/schemas/_types:Duration"},"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["origin","pivot","field"]}]},"_types:DateMath":{"type":"string"},"_types:Duration":{"externalDocs":{"url":"https://github.com/elastic/elasticsearch/blob/current/libs/core/src/main/java/org/elasticsearch/core/TimeValue.java"},"description":"A duration. Units can be `nanos`, `micros`, `ms` (milliseconds), `s` (seconds), `m` (minutes), `h` (hours) and\\n`d` (days). Also accepts \\"0\\" without a unit and \\"-1\\" to indicate an unspecified value.","oneOf":[{"type":"string"},{"type":"string","enum":["-1"]},{"type":"string","enum":["0"]}]},"_types.query_dsl:ExistsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"}},"required":["field"]}]},"_types.query_dsl:FunctionScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"boost_mode":{"$ref":"#/components/schemas/_types.query_dsl:FunctionBoostMode"},"functions":{"description":"One or more functions that compute a new score for each document returned by the query.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreContainer"}},"max_boost":{"description":"Restricts the new score to not exceed the provided limit.","type":"number"},"min_score":{"description":"Excludes documents that do not meet the provided score threshold.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:FunctionScoreMode"}}}]},"_types.query_dsl:FunctionBoostMode":{"type":"string","enum":["multiply","replace","sum","avg","max","min"]},"_types.query_dsl:FunctionScoreContainer":{"allOf":[{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"weight":{"type":"number"}}},{"type":"object","properties":{"exp":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"gauss":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"linear":{"$ref":"#/components/schemas/_types.query_dsl:DecayFunction"},"field_value_factor":{"$ref":"#/components/schemas/_types.query_dsl:FieldValueFactorScoreFunction"},"random_score":{"$ref":"#/components/schemas/_types.query_dsl:RandomScoreFunction"},"script_score":{"$ref":"#/components/schemas/_types.query_dsl:ScriptScoreFunction"}},"minProperties":1,"maxProperties":1}]},"_types.query_dsl:DecayFunction":{"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:DateDecayFunction"},{"$ref":"#/components/schemas/_types.query_dsl:NumericDecayFunction"},{"$ref":"#/components/schemas/_types.query_dsl:GeoDecayFunction"}]},"_types.query_dsl:DateDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBase"},{"type":"object"}]},"_types.query_dsl:DecayFunctionBase":{"type":"object","properties":{"multi_value_mode":{"$ref":"#/components/schemas/_types.query_dsl:MultiValueMode"}}},"_types.query_dsl:MultiValueMode":{"type":"string","enum":["min","max","avg","sum"]},"_types.query_dsl:NumericDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBase"},{"type":"object"}]},"_types.query_dsl:GeoDecayFunction":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:DecayFunctionBase"},{"type":"object"}]},"_types.query_dsl:FieldValueFactorScoreFunction":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"factor":{"description":"Optional factor to multiply the field value with.","type":"number"},"missing":{"description":"Value used if the document doesn’t have that field.\\nThe modifier and factor are still applied to it as though it were read from the document.","type":"number"},"modifier":{"$ref":"#/components/schemas/_types.query_dsl:FieldValueFactorModifier"}},"required":["field"]},"_types.query_dsl:FieldValueFactorModifier":{"type":"string","enum":["none","log","log1p","log2p","ln","ln1p","ln2p","square","sqrt","reciprocal"]},"_types.query_dsl:RandomScoreFunction":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"seed":{"oneOf":[{"type":"number"},{"type":"string"}]}}},"_types.query_dsl:ScriptScoreFunction":{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["script"]},"_types:Script":{"oneOf":[{"$ref":"#/components/schemas/_types:InlineScript"},{"$ref":"#/components/schemas/_types:StoredScriptId"}]},"_types:InlineScript":{"allOf":[{"$ref":"#/components/schemas/_types:ScriptBase"},{"type":"object","properties":{"lang":{"$ref":"#/components/schemas/_types:ScriptLanguage"},"options":{"type":"object","additionalProperties":{"type":"string"}},"source":{"description":"The script source.","type":"string"}},"required":["source"]}]},"_types:ScriptBase":{"type":"object","properties":{"params":{"description":"Specifies any named parameters that are passed into the script as variables.\\nUse parameters instead of hard-coded values to decrease compile time.","type":"object","additionalProperties":{"type":"object"}}}},"_types:ScriptLanguage":{"anyOf":[{"type":"string","enum":["painless","expression","mustache","java"]},{"type":"string"}]},"_types:StoredScriptId":{"allOf":[{"$ref":"#/components/schemas/_types:ScriptBase"},{"type":"object","properties":{"id":{"$ref":"#/components/schemas/_types:Id"}},"required":["id"]}]},"_types:Id":{"type":"string"},"_types.query_dsl:FunctionScoreMode":{"type":"string","enum":["multiply","sum","avg","first","max","min"]},"_types.query_dsl:FuzzyQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"max_expansions":{"description":"Maximum number of variations created.","type":"number"},"prefix_length":{"description":"Number of beginning characters left unchanged when creating expansions.","type":"number"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"transpositions":{"description":"Indicates whether edits include transpositions of two adjacent characters (for example `ab` to `ba`).","type":"boolean"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"value":{"description":"Term you wish to find in the provided field.","oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"}]}},"required":["value"]}]},"_types:MultiTermQueryRewrite":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-multi-term-rewrite.html"},"type":"string"},"_types:Fuzziness":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/common-options.html#fuzziness"},"oneOf":[{"type":"string"},{"type":"number"}]},"_types.query_dsl:GeoBoundingBoxQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_types.query_dsl:GeoExecution"},"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}}}]},"_types.query_dsl:GeoExecution":{"type":"string","enum":["memory","indexed"]},"_types.query_dsl:GeoValidationMethod":{"type":"string","enum":["coerce","ignore_malformed","strict"]},"_types.query_dsl:GeoDistanceQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"distance":{"$ref":"#/components/schemas/_types:Distance"},"distance_type":{"$ref":"#/components/schemas/_types:GeoDistanceType"},"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}},"required":["distance"]}]},"_types:GeoDistanceType":{"type":"string","enum":["arc","plane"]},"_types.query_dsl:GeoPolygonQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"validation_method":{"$ref":"#/components/schemas/_types.query_dsl:GeoValidationMethod"},"ignore_unmapped":{"type":"boolean"}}}]},"_types.query_dsl:GeoShapeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Set to `true` to ignore an unmapped field and not match any documents for this query.\\nSet to `false` to throw an exception if the field is not mapped.","type":"boolean"}}}]},"_types.query_dsl:HasChildQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `type` and not return any documents instead of an error.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"max_children":{"description":"Maximum number of child documents that match the query allowed for a returned parent document.\\nIf the parent document exceeds this limit, it is excluded from the search results.","type":"number"},"min_children":{"description":"Minimum number of child documents that match the query required to match the query for a returned parent document.\\nIf the parent document does not meet this limit, it is excluded from the search results.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:ChildScoreMode"},"type":{"$ref":"#/components/schemas/_types:RelationName"}},"required":["query","type"]}]},"_global.search._types:InnerHits":{"type":"object","properties":{"name":{"$ref":"#/components/schemas/_types:Name"},"size":{"description":"The maximum number of hits to return per `inner_hits`.","type":"number"},"from":{"description":"Inner hit starting document offset.","type":"number"},"collapse":{"$ref":"#/components/schemas/_global.search._types:FieldCollapse"},"docvalue_fields":{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:FieldAndFormat"}},"explain":{"type":"boolean"},"highlight":{"$ref":"#/components/schemas/_global.search._types:Highlight"},"ignore_unmapped":{"type":"boolean"},"script_fields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types:ScriptField"}},"seq_no_primary_term":{"type":"boolean"},"fields":{"$ref":"#/components/schemas/_types:Fields"},"sort":{"$ref":"#/components/schemas/_types:Sort"},"_source":{"$ref":"#/components/schemas/_global.search._types:SourceConfig"},"stored_fields":{"$ref":"#/components/schemas/_types:Fields"},"track_scores":{"type":"boolean"},"version":{"type":"boolean"}}},"_global.search._types:FieldCollapse":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"inner_hits":{"description":"The number of inner hits and their sort order","oneOf":[{"$ref":"#/components/schemas/_global.search._types:InnerHits"},{"type":"array","items":{"$ref":"#/components/schemas/_global.search._types:InnerHits"}}]},"max_concurrent_group_searches":{"description":"The number of concurrent requests allowed to retrieve the inner_hits per group","type":"number"},"collapse":{"$ref":"#/components/schemas/_global.search._types:FieldCollapse"}},"required":["field"]},"_types.query_dsl:FieldAndFormat":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"description":"Format in which the values are returned.","type":"string"},"include_unmapped":{"type":"boolean"}},"required":["field"]},"_global.search._types:Highlight":{"allOf":[{"$ref":"#/components/schemas/_global.search._types:HighlightBase"},{"type":"object","properties":{"encoder":{"$ref":"#/components/schemas/_global.search._types:HighlighterEncoder"},"fields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_global.search._types:HighlightField"}}},"required":["fields"]}]},"_global.search._types:HighlightBase":{"type":"object","properties":{"type":{"$ref":"#/components/schemas/_global.search._types:HighlighterType"},"boundary_chars":{"description":"A string that contains each boundary character.","type":"string"},"boundary_max_scan":{"description":"How far to scan for boundary characters.","type":"number"},"boundary_scanner":{"$ref":"#/components/schemas/_global.search._types:BoundaryScanner"},"boundary_scanner_locale":{"description":"Controls which locale is used to search for sentence and word boundaries.\\nThis parameter takes a form of a language tag, for example: `\\"en-US\\"`, `\\"fr-FR\\"`, `\\"ja-JP\\"`.","type":"string"},"force_source":{"deprecated":true,"type":"boolean"},"fragmenter":{"$ref":"#/components/schemas/_global.search._types:HighlighterFragmenter"},"fragment_size":{"description":"The size of the highlighted fragment in characters.","type":"number"},"highlight_filter":{"type":"boolean"},"highlight_query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"max_fragment_length":{"type":"number"},"max_analyzed_offset":{"description":"If set to a non-negative value, highlighting stops at this defined maximum limit.\\nThe rest of the text is not processed, thus not highlighted and no error is returned\\nThe `max_analyzed_offset` query setting does not override the `index.highlight.max_analyzed_offset` setting, which prevails when it’s set to lower value than the query setting.","type":"number"},"no_match_size":{"description":"The amount of text you want to return from the beginning of the field if there are no matching fragments to highlight.","type":"number"},"number_of_fragments":{"description":"The maximum number of fragments to return.\\nIf the number of fragments is set to `0`, no fragments are returned.\\nInstead, the entire field contents are highlighted and returned.\\nThis can be handy when you need to highlight short texts such as a title or address, but fragmentation is not required.\\nIf `number_of_fragments` is `0`, `fragment_size` is ignored.","type":"number"},"options":{"type":"object","additionalProperties":{"type":"object"}},"order":{"$ref":"#/components/schemas/_global.search._types:HighlighterOrder"},"phrase_limit":{"description":"Controls the number of matching phrases in a document that are considered.\\nPrevents the `fvh` highlighter from analyzing too many phrases and consuming too much memory.\\nWhen using `matched_fields`, `phrase_limit` phrases per matched field are considered. Raising the limit increases query time and consumes more memory.\\nOnly supported by the `fvh` highlighter.","type":"number"},"post_tags":{"description":"Use in conjunction with `pre_tags` to define the HTML tags to use for the highlighted text.\\nBy default, highlighted text is wrapped in `<em>` and `</em>` tags.","type":"array","items":{"type":"string"}},"pre_tags":{"description":"Use in conjunction with `post_tags` to define the HTML tags to use for the highlighted text.\\nBy default, highlighted text is wrapped in `<em>` and `</em>` tags.","type":"array","items":{"type":"string"}},"require_field_match":{"description":"By default, only fields that contains a query match are highlighted.\\nSet to `false` to highlight all fields.","type":"boolean"},"tags_schema":{"$ref":"#/components/schemas/_global.search._types:HighlighterTagsSchema"}}},"_global.search._types:HighlighterType":{"anyOf":[{"type":"string","enum":["plain","fvh","unified"]},{"type":"string"}]},"_global.search._types:BoundaryScanner":{"type":"string","enum":["chars","sentence","word"]},"_global.search._types:HighlighterFragmenter":{"type":"string","enum":["simple","span"]},"_global.search._types:HighlighterOrder":{"type":"string","enum":["score"]},"_global.search._types:HighlighterTagsSchema":{"type":"string","enum":["styled"]},"_global.search._types:HighlighterEncoder":{"type":"string","enum":["default","html"]},"_global.search._types:HighlightField":{"allOf":[{"$ref":"#/components/schemas/_global.search._types:HighlightBase"},{"type":"object","properties":{"fragment_offset":{"type":"number"},"matched_fields":{"$ref":"#/components/schemas/_types:Fields"},"analyzer":{"$ref":"#/components/schemas/_types.analysis:Analyzer"}}}]},"_types:Fields":{"oneOf":[{"$ref":"#/components/schemas/_types:Field"},{"type":"array","items":{"$ref":"#/components/schemas/_types:Field"}}]},"_types.analysis:Analyzer":{"discriminator":{"propertyName":"type"},"oneOf":[{"$ref":"#/components/schemas/_types.analysis:CustomAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:FingerprintAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:KeywordAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:LanguageAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:NoriAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:PatternAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:SimpleAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:StandardAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:StopAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:WhitespaceAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:IcuAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:KuromojiAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:SnowballAnalyzer"},{"$ref":"#/components/schemas/_types.analysis:DutchAnalyzer"}]},"_types.analysis:CustomAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["custom"]},"char_filter":{"type":"array","items":{"type":"string"}},"filter":{"type":"array","items":{"type":"string"}},"position_increment_gap":{"type":"number"},"position_offset_gap":{"type":"number"},"tokenizer":{"type":"string"}},"required":["type","tokenizer"]},"_types.analysis:FingerprintAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["fingerprint"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"max_output_size":{"type":"number"},"preserve_original":{"type":"boolean"},"separator":{"type":"string"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"stopwords_path":{"type":"string"}},"required":["type","max_output_size","preserve_original","separator"]},"_types:VersionString":{"type":"string"},"_types.analysis:StopWords":{"description":"Language value, such as _arabic_ or _thai_. Defaults to _english_.\\nEach language value corresponds to a predefined list of stop words in Lucene. See Stop words by language for supported language values and their stop words.\\nAlso accepts an array of stop words.","oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"_types.analysis:KeywordAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["keyword"]},"version":{"$ref":"#/components/schemas/_types:VersionString"}},"required":["type"]},"_types.analysis:LanguageAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["language"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"language":{"$ref":"#/components/schemas/_types.analysis:Language"},"stem_exclusion":{"type":"array","items":{"type":"string"}},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"stopwords_path":{"type":"string"}},"required":["type","language","stem_exclusion"]},"_types.analysis:Language":{"type":"string","enum":["Arabic","Armenian","Basque","Brazilian","Bulgarian","Catalan","Chinese","Cjk","Czech","Danish","Dutch","English","Estonian","Finnish","French","Galician","German","Greek","Hindi","Hungarian","Indonesian","Irish","Italian","Latvian","Norwegian","Persian","Portuguese","Romanian","Russian","Sorani","Spanish","Swedish","Turkish","Thai"]},"_types.analysis:NoriAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["nori"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"decompound_mode":{"$ref":"#/components/schemas/_types.analysis:NoriDecompoundMode"},"stoptags":{"type":"array","items":{"type":"string"}},"user_dictionary":{"type":"string"}},"required":["type"]},"_types.analysis:NoriDecompoundMode":{"type":"string","enum":["discard","none","mixed"]},"_types.analysis:PatternAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["pattern"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"flags":{"type":"string"},"lowercase":{"type":"boolean"},"pattern":{"type":"string"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"}},"required":["type","pattern"]},"_types.analysis:SimpleAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["simple"]},"version":{"$ref":"#/components/schemas/_types:VersionString"}},"required":["type"]},"_types.analysis:StandardAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["standard"]},"max_token_length":{"type":"number"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"}},"required":["type"]},"_types.analysis:StopAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["stop"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"stopwords_path":{"type":"string"}},"required":["type"]},"_types.analysis:WhitespaceAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["whitespace"]},"version":{"$ref":"#/components/schemas/_types:VersionString"}},"required":["type"]},"_types.analysis:IcuAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["icu_analyzer"]},"method":{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationType"},"mode":{"$ref":"#/components/schemas/_types.analysis:IcuNormalizationMode"}},"required":["type","method","mode"]},"_types.analysis:IcuNormalizationType":{"type":"string","enum":["nfc","nfkc","nfkc_cf"]},"_types.analysis:IcuNormalizationMode":{"type":"string","enum":["decompose","compose"]},"_types.analysis:KuromojiAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["kuromoji"]},"mode":{"$ref":"#/components/schemas/_types.analysis:KuromojiTokenizationMode"},"user_dictionary":{"type":"string"}},"required":["type","mode"]},"_types.analysis:KuromojiTokenizationMode":{"type":"string","enum":["normal","search","extended"]},"_types.analysis:SnowballAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["snowball"]},"version":{"$ref":"#/components/schemas/_types:VersionString"},"language":{"$ref":"#/components/schemas/_types.analysis:SnowballLanguage"},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"}},"required":["type","language"]},"_types.analysis:SnowballLanguage":{"type":"string","enum":["Armenian","Basque","Catalan","Danish","Dutch","English","Finnish","French","German","German2","Hungarian","Italian","Kp","Lovins","Norwegian","Porter","Portuguese","Romanian","Russian","Spanish","Swedish","Turkish"]},"_types.analysis:DutchAnalyzer":{"type":"object","properties":{"type":{"type":"string","enum":["dutch"]},"stopwords":{"$ref":"#/components/schemas/_types.analysis:StopWords"}},"required":["type"]},"_types:ScriptField":{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"},"ignore_failure":{"type":"boolean"}},"required":["script"]},"_types:Sort":{"oneOf":[{"$ref":"#/components/schemas/_types:SortCombinations"},{"type":"array","items":{"$ref":"#/components/schemas/_types:SortCombinations"}}]},"_types:SortCombinations":{"oneOf":[{"$ref":"#/components/schemas/_types:Field"},{"$ref":"#/components/schemas/_types:SortOptions"}]},"_types:SortOptions":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/sort-search-results.html"},"type":"object","properties":{"_score":{"$ref":"#/components/schemas/_types:ScoreSort"},"_doc":{"$ref":"#/components/schemas/_types:ScoreSort"},"_geo_distance":{"$ref":"#/components/schemas/_types:GeoDistanceSort"},"_script":{"$ref":"#/components/schemas/_types:ScriptSort"}},"minProperties":1,"maxProperties":1},"_types:ScoreSort":{"type":"object","properties":{"order":{"$ref":"#/components/schemas/_types:SortOrder"}}},"_types:SortOrder":{"type":"string","enum":["asc","desc"]},"_types:GeoDistanceSort":{"type":"object","properties":{"mode":{"$ref":"#/components/schemas/_types:SortMode"},"distance_type":{"$ref":"#/components/schemas/_types:GeoDistanceType"},"ignore_unmapped":{"type":"boolean"},"order":{"$ref":"#/components/schemas/_types:SortOrder"},"unit":{"$ref":"#/components/schemas/_types:DistanceUnit"}}},"_types:SortMode":{"type":"string","enum":["min","max","sum","avg","median"]},"_types:DistanceUnit":{"type":"string","enum":["in","ft","yd","mi","nmi","km","m","cm","mm"]},"_types:ScriptSort":{"type":"object","properties":{"order":{"$ref":"#/components/schemas/_types:SortOrder"},"script":{"$ref":"#/components/schemas/_types:Script"},"type":{"$ref":"#/components/schemas/_types:ScriptSortType"},"mode":{"$ref":"#/components/schemas/_types:SortMode"},"nested":{"$ref":"#/components/schemas/_types:NestedSortValue"}},"required":["script"]},"_types:ScriptSortType":{"type":"string","enum":["string","number","version"]},"_types:NestedSortValue":{"type":"object","properties":{"filter":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"max_children":{"type":"number"},"nested":{"$ref":"#/components/schemas/_types:NestedSortValue"},"path":{"$ref":"#/components/schemas/_types:Field"}},"required":["path"]},"_global.search._types:SourceConfig":{"description":"Defines how to fetch a source. Fetching can be disabled entirely, or the source can be filtered.","oneOf":[{"type":"boolean"},{"$ref":"#/components/schemas/_global.search._types:SourceFilter"}]},"_global.search._types:SourceFilter":{"type":"object","properties":{"excludes":{"$ref":"#/components/schemas/_types:Fields"},"includes":{"$ref":"#/components/schemas/_types:Fields"}}},"_types.query_dsl:ChildScoreMode":{"type":"string","enum":["none","avg","sum","max","min"]},"_types:RelationName":{"type":"string"},"_types.query_dsl:HasParentQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `parent_type` and not return any documents instead of an error.\\nYou can use this parameter to query multiple indices that may not contain the `parent_type`.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"parent_type":{"$ref":"#/components/schemas/_types:RelationName"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score":{"description":"Indicates whether the relevance score of a matching parent document is aggregated into its child documents.","type":"boolean"}},"required":["parent_type","query"]}]},"_types.query_dsl:IdsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"values":{"$ref":"#/components/schemas/_types:Ids"}}}]},"_types:Ids":{"oneOf":[{"$ref":"#/components/schemas/_types:Id"},{"type":"array","items":{"$ref":"#/components/schemas/_types:Id"}}]},"_types.query_dsl:IntervalsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"all_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAllOf"},"any_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAnyOf"},"fuzzy":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFuzzy"},"match":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsMatch"},"prefix":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsPrefix"},"wildcard":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsWildcard"}},"minProperties":1,"maxProperties":1}]},"_types.query_dsl:IntervalsAllOf":{"type":"object","properties":{"intervals":{"description":"An array of rules to combine. All rules must produce a match in a document for the overall source to match.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"}},"max_gaps":{"description":"Maximum number of positions between the matching terms.\\nIntervals produced by the rules further apart than this are not considered matches.","type":"number"},"ordered":{"description":"If `true`, intervals produced by the rules should appear in the order in which they are specified.","type":"boolean"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["intervals"]},"_types.query_dsl:IntervalsContainer":{"type":"object","properties":{"all_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAllOf"},"any_of":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsAnyOf"},"fuzzy":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFuzzy"},"match":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsMatch"},"prefix":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsPrefix"},"wildcard":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsWildcard"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:IntervalsAnyOf":{"type":"object","properties":{"intervals":{"description":"An array of rules to match.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"}},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["intervals"]},"_types.query_dsl:IntervalsFilter":{"type":"object","properties":{"after":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"before":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"contained_by":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"containing":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_contained_by":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_containing":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"not_overlapping":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"overlapping":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsContainer"},"script":{"$ref":"#/components/schemas/_types:Script"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:IntervalsFuzzy":{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to normalize the term.","type":"string"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"prefix_length":{"description":"Number of beginning characters left unchanged when creating expansions.","type":"number"},"term":{"description":"The term to match.","type":"string"},"transpositions":{"description":"Indicates whether edits include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["term"]},"_types.query_dsl:IntervalsMatch":{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to analyze terms in the query.","type":"string"},"max_gaps":{"description":"Maximum number of positions between the matching terms.\\nTerms further apart than this are not considered matches.","type":"number"},"ordered":{"description":"If `true`, matching terms must appear in their specified order.","type":"boolean"},"query":{"description":"Text you wish to find in the provided field.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"},"filter":{"$ref":"#/components/schemas/_types.query_dsl:IntervalsFilter"}},"required":["query"]},"_types.query_dsl:IntervalsPrefix":{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to analyze the `prefix`.","type":"string"},"prefix":{"description":"Beginning characters of terms you wish to find in the top-level field.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["prefix"]},"_types.query_dsl:IntervalsWildcard":{"type":"object","properties":{"analyzer":{"description":"Analyzer used to analyze the `pattern`.\\nDefaults to the top-level field\'s analyzer.","type":"string"},"pattern":{"description":"Wildcard pattern used to find matching terms.","type":"string"},"use_field":{"$ref":"#/components/schemas/_types:Field"}},"required":["pattern"]},"_types:KnnQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"query_vector":{"$ref":"#/components/schemas/_types:QueryVector"},"query_vector_builder":{"$ref":"#/components/schemas/_types:QueryVectorBuilder"},"num_candidates":{"description":"The number of nearest neighbor candidates to consider per shard","type":"number"},"filter":{"description":"Filters for the kNN search query","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}}]},"similarity":{"description":"The minimum similarity for a vector to be considered a match","type":"number"}},"required":["field"]}]},"_types:QueryVector":{"type":"array","items":{"type":"number"}},"_types:QueryVectorBuilder":{"type":"object","properties":{"text_embedding":{"$ref":"#/components/schemas/_types:TextEmbedding"}},"minProperties":1,"maxProperties":1},"_types:TextEmbedding":{"type":"object","properties":{"model_id":{"type":"string"},"model_text":{"type":"string"}},"required":["model_id","model_text"]},"_types.query_dsl:MatchQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"cutoff_frequency":{"deprecated":true,"type":"number"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"query":{"description":"Text, number, boolean value or date you wish to find in the provided field.","oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"}]},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:ZeroTermsQuery":{"type":"string","enum":["all","none"]},"_types.query_dsl:MatchAllQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:MatchBoolPrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"number"},"query":{"description":"Terms you wish to find in the provided field.\\nThe last term is used in a prefix query.","type":"string"}},"required":["query"]}]},"_types.query_dsl:MatchNoneQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:MatchPhraseQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"query":{"description":"Query terms that are analyzed and turned into a phrase query.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:MatchPhrasePrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert text in the query value into tokens.","type":"string"},"max_expansions":{"description":"Maximum number of terms to which the last provided term of the query value will expand.","type":"number"},"query":{"description":"Text you wish to find in the provided field.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:MoreLikeThisQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"The analyzer that is used to analyze the free form text.\\nDefaults to the analyzer associated with the first field in fields.","type":"string"},"boost_terms":{"description":"Each term in the formed query could be further boosted by their tf-idf score.\\nThis sets the boost factor to use when using this feature.\\nDefaults to deactivated (0).","type":"number"},"fail_on_unsupported_field":{"description":"Controls whether the query should fail (throw an exception) if any of the specified fields are not of the supported types (`text` or `keyword`).","type":"boolean"},"fields":{"description":"A list of fields to fetch and analyze the text from.\\nDefaults to the `index.query.default_field` index setting, which has a default value of `*`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"include":{"description":"Specifies whether the input documents should also be included in the search results returned.","type":"boolean"},"like":{"description":"Specifies free form text and/or a single or multiple documents for which you want to find similar documents.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:Like"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:Like"}}]},"max_doc_freq":{"description":"The maximum document frequency above which the terms are ignored from the input document.","type":"number"},"max_query_terms":{"description":"The maximum number of query terms that can be selected.","type":"number"},"max_word_length":{"description":"The maximum word length above which the terms are ignored.\\nDefaults to unbounded (`0`).","type":"number"},"min_doc_freq":{"description":"The minimum document frequency below which the terms are ignored from the input document.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"min_term_freq":{"description":"The minimum term frequency below which the terms are ignored from the input document.","type":"number"},"min_word_length":{"description":"The minimum word length below which the terms are ignored.","type":"number"},"routing":{"$ref":"#/components/schemas/_types:Routing"},"stop_words":{"$ref":"#/components/schemas/_types.analysis:StopWords"},"unlike":{"description":"Used in combination with `like` to exclude documents that match a set of terms.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:Like"},{"type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:Like"}}]},"version":{"$ref":"#/components/schemas/_types:VersionNumber"},"version_type":{"$ref":"#/components/schemas/_types:VersionType"}},"required":["like"]}]},"_types.query_dsl:Like":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-mlt-query.html#_document_input_parameters"},"description":"Text that we want similar documents for or a lookup to a document\'s field for the text.","oneOf":[{"type":"string"},{"$ref":"#/components/schemas/_types.query_dsl:LikeDocument"}]},"_types.query_dsl:LikeDocument":{"type":"object","properties":{"doc":{"description":"A document not present in the index.","type":"object"},"fields":{"type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"_id":{"$ref":"#/components/schemas/_types:Id"},"_index":{"$ref":"#/components/schemas/_types:IndexName"},"per_field_analyzer":{"description":"Overrides the default analyzer.","type":"object","additionalProperties":{"type":"string"}},"routing":{"$ref":"#/components/schemas/_types:Routing"},"version":{"$ref":"#/components/schemas/_types:VersionNumber"},"version_type":{"$ref":"#/components/schemas/_types:VersionType"}}},"_types:Routing":{"type":"string"},"_types:VersionNumber":{"type":"number"},"_types:VersionType":{"type":"string","enum":["internal","external","external_gte","force"]},"_types.query_dsl:MultiMatchQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert the text in the query value into tokens.","type":"string"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"cutoff_frequency":{"deprecated":true,"type":"number"},"fields":{"$ref":"#/components/schemas/_types:Fields"},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).\\nCan be applied to the term subqueries constructed for all terms but the final term.","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text query value for a numeric field, are ignored.","type":"boolean"},"max_expansions":{"description":"Maximum number of terms to which the query will expand.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"query":{"description":"Text, number, boolean value or date you wish to find in the provided field.","type":"string"},"slop":{"description":"Maximum number of positions allowed between matching tokens.","type":"number"},"tie_breaker":{"description":"Determines how scores for each per-term blended query and scores across groups are combined.","type":"number"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TextQueryType"},"zero_terms_query":{"$ref":"#/components/schemas/_types.query_dsl:ZeroTermsQuery"}},"required":["query"]}]},"_types.query_dsl:TextQueryType":{"type":"string","enum":["best_fields","most_fields","cross_fields","phrase","phrase_prefix","bool_prefix"]},"_types.query_dsl:NestedQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped path and not return any documents instead of an error.","type":"boolean"},"inner_hits":{"$ref":"#/components/schemas/_global.search._types:InnerHits"},"path":{"$ref":"#/components/schemas/_types:Field"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"score_mode":{"$ref":"#/components/schemas/_types.query_dsl:ChildScoreMode"}},"required":["path","query"]}]},"_types.query_dsl:ParentIdQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"id":{"$ref":"#/components/schemas/_types:Id"},"ignore_unmapped":{"description":"Indicates whether to ignore an unmapped `type` and not return any documents instead of an error.","type":"boolean"},"type":{"$ref":"#/components/schemas/_types:RelationName"}}}]},"_types.query_dsl:PercolateQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"document":{"description":"The source of the document being percolated.","type":"object"},"documents":{"description":"An array of sources of the documents being percolated.","type":"array","items":{"type":"object"}},"field":{"$ref":"#/components/schemas/_types:Field"},"id":{"$ref":"#/components/schemas/_types:Id"},"index":{"$ref":"#/components/schemas/_types:IndexName"},"name":{"description":"The suffix used for the `_percolator_document_slot` field when multiple `percolate` queries are specified.","type":"string"},"preference":{"description":"Preference used to fetch document to percolate.","type":"string"},"routing":{"$ref":"#/components/schemas/_types:Routing"},"version":{"$ref":"#/components/schemas/_types:VersionNumber"}},"required":["field"]}]},"_types.query_dsl:PinnedQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"allOf":[{"type":"object","properties":{"organic":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["organic"]},{"type":"object","properties":{"ids":{"description":"Document IDs listed in the order they are to appear in results.\\nRequired if `docs` is not specified.","type":"array","items":{"$ref":"#/components/schemas/_types:Id"}},"docs":{"description":"Documents listed in the order they are to appear in results.\\nRequired if `ids` is not specified.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:PinnedDoc"}}},"minProperties":1,"maxProperties":1}]}]},"_types.query_dsl:PinnedDoc":{"type":"object","properties":{"_id":{"$ref":"#/components/schemas/_types:Id"},"_index":{"$ref":"#/components/schemas/_types:IndexName"}},"required":["_id","_index"]},"_types.query_dsl:PrefixQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"description":"Beginning characters of terms you wish to find in the provided field.","type":"string"},"case_insensitive":{"description":"Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.\\nDefault is `false` which means the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"}},"required":["value"]}]},"_types.query_dsl:QueryStringQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"allow_leading_wildcard":{"description":"If `true`, the wildcard characters `*` and `?` are allowed as the first character of the query string.","type":"boolean"},"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert text in the query string into tokens.","type":"string"},"analyze_wildcard":{"description":"If `true`, the query attempts to analyze wildcard terms in the query string.","type":"boolean"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, match phrase queries are automatically created for multi-term synonyms.","type":"boolean"},"default_field":{"$ref":"#/components/schemas/_types:Field"},"default_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"enable_position_increments":{"description":"If `true`, enable position increments in queries constructed from a `query_string` search.","type":"boolean"},"escape":{"type":"boolean"},"fields":{"description":"Array of fields to search. Supports wildcards (`*`).","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"fuzziness":{"$ref":"#/components/schemas/_types:Fuzziness"},"fuzzy_max_expansions":{"description":"Maximum number of terms to which the query expands for fuzzy matching.","type":"number"},"fuzzy_prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"fuzzy_rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text value for a numeric field, are ignored.","type":"boolean"},"max_determinized_states":{"description":"Maximum number of automaton states required for the query.","type":"number"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"phrase_slop":{"description":"Maximum number of positions allowed between matching tokens for phrases.","type":"number"},"query":{"description":"Query string you wish to parse and use for search.","type":"string"},"quote_analyzer":{"description":"Analyzer used to convert quoted text in the query string into tokens.\\nFor quoted text, this parameter overrides the analyzer specified in the `analyzer` parameter.","type":"string"},"quote_field_suffix":{"description":"Suffix appended to quoted text in the query string.\\nYou can use this suffix to use a different analysis method for exact matches.","type":"string"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"tie_breaker":{"description":"How to combine the queries generated from the individual search terms in the resulting `dis_max` query.","type":"number"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"},"type":{"$ref":"#/components/schemas/_types.query_dsl:TextQueryType"}},"required":["query"]}]},"_types:TimeZone":{"type":"string"},"_types.query_dsl:RangeQuery":{"oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:DateRangeQuery"},{"$ref":"#/components/schemas/_types.query_dsl:NumberRangeQuery"},{"$ref":"#/components/schemas/_types.query_dsl:TermsRangeQuery"}]},"_types.query_dsl:DateRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBase"},{"type":"object","properties":{"gt":{"$ref":"#/components/schemas/_types:DateMath"},"gte":{"$ref":"#/components/schemas/_types:DateMath"},"lt":{"$ref":"#/components/schemas/_types:DateMath"},"lte":{"$ref":"#/components/schemas/_types:DateMath"},"from":{"oneOf":[{"$ref":"#/components/schemas/_types:DateMath"},{"nullable":true,"type":"string"}]},"to":{"oneOf":[{"$ref":"#/components/schemas/_types:DateMath"},{"nullable":true,"type":"string"}]},"format":{"$ref":"#/components/schemas/_types:DateFormat"},"time_zone":{"$ref":"#/components/schemas/_types:TimeZone"}}}]},"_types.query_dsl:RangeQueryBase":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"relation":{"$ref":"#/components/schemas/_types.query_dsl:RangeRelation"}}}]},"_types.query_dsl:RangeRelation":{"type":"string","enum":["within","contains","intersects"]},"_types:DateFormat":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-date-format.html"},"type":"string"},"_types.query_dsl:NumberRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBase"},{"type":"object","properties":{"gt":{"description":"Greater than.","type":"number"},"gte":{"description":"Greater than or equal to.","type":"number"},"lt":{"description":"Less than.","type":"number"},"lte":{"description":"Less than or equal to.","type":"number"},"from":{"oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]},"to":{"oneOf":[{"type":"number"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:TermsRangeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RangeQueryBase"},{"type":"object","properties":{"gt":{"description":"Greater than.","type":"string"},"gte":{"description":"Greater than or equal to.","type":"string"},"lt":{"description":"Less than.","type":"string"},"lte":{"description":"Less than or equal to.","type":"string"},"from":{"oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]},"to":{"oneOf":[{"type":"string"},{"nullable":true,"type":"string"}]}}}]},"_types.query_dsl:RankFeatureQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"saturation":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionSaturation"},"log":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionLogarithm"},"linear":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionLinear"},"sigmoid":{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunctionSigmoid"}},"required":["field"]}]},"_types.query_dsl:RankFeatureFunctionSaturation":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"pivot":{"description":"Configurable pivot value so that the result will be less than 0.5.","type":"number"}}}]},"_types.query_dsl:RankFeatureFunction":{"type":"object"},"_types.query_dsl:RankFeatureFunctionLogarithm":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"scaling_factor":{"description":"Configurable scaling factor.","type":"number"}},"required":["scaling_factor"]}]},"_types.query_dsl:RankFeatureFunctionLinear":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object"}]},"_types.query_dsl:RankFeatureFunctionSigmoid":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:RankFeatureFunction"},{"type":"object","properties":{"pivot":{"description":"Configurable pivot value so that the result will be less than 0.5.","type":"number"},"exponent":{"description":"Configurable Exponent.","type":"number"}},"required":["pivot","exponent"]}]},"_types.query_dsl:RegexpQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"case_insensitive":{"description":"Allows case insensitive matching of the regular expression value with the indexed field values when set to `true`.\\nWhen `false`, case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"},"flags":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/regexp-syntax.html"},"description":"Enables optional operators for the regular expression.","type":"string"},"max_determinized_states":{"description":"Maximum number of automaton states required for the query.","type":"number"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/regexp-syntax.html"},"description":"Regular expression for terms you wish to find in the provided field.","type":"string"}},"required":["value"]}]},"_types.query_dsl:RuleQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"organic":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"ruleset_id":{"$ref":"#/components/schemas/_types:Id"},"match_criteria":{"type":"object"}},"required":["organic","ruleset_id","match_criteria"]}]},"_types.query_dsl:ScriptQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["script"]}]},"_types.query_dsl:ScriptScoreQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"min_score":{"description":"Documents with a score lower than this floating point number are excluded from the search results.","type":"number"},"query":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"},"script":{"$ref":"#/components/schemas/_types:Script"}},"required":["query","script"]}]},"_types.query_dsl:ShapeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"ignore_unmapped":{"description":"When set to `true` the query ignores an unmapped field and will not match any documents.","type":"boolean"}}}]},"_types.query_dsl:SimpleQueryStringQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"analyzer":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/analysis.html"},"description":"Analyzer used to convert text in the query string into tokens.","type":"string"},"analyze_wildcard":{"description":"If `true`, the query attempts to analyze wildcard terms in the query string.","type":"boolean"},"auto_generate_synonyms_phrase_query":{"description":"If `true`, the parser creates a match_phrase query for each multi-position token.","type":"boolean"},"default_operator":{"$ref":"#/components/schemas/_types.query_dsl:Operator"},"fields":{"description":"Array of fields you wish to search.\\nAccepts wildcard expressions.\\nYou also can boost relevance scores for matches to particular fields using a caret (`^`) notation.\\nDefaults to the `index.query.default_field index` setting, which has a default value of `*`.","type":"array","items":{"$ref":"#/components/schemas/_types:Field"}},"flags":{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringFlags"},"fuzzy_max_expansions":{"description":"Maximum number of terms to which the query expands for fuzzy matching.","type":"number"},"fuzzy_prefix_length":{"description":"Number of beginning characters left unchanged for fuzzy matching.","type":"number"},"fuzzy_transpositions":{"description":"If `true`, edits for fuzzy matching include transpositions of two adjacent characters (for example, `ab` to `ba`).","type":"boolean"},"lenient":{"description":"If `true`, format-based errors, such as providing a text value for a numeric field, are ignored.","type":"boolean"},"minimum_should_match":{"$ref":"#/components/schemas/_types:MinimumShouldMatch"},"query":{"description":"Query string in the simple query string syntax you wish to parse and use for search.","type":"string"},"quote_field_suffix":{"description":"Suffix appended to quoted text in the query string.","type":"string"}},"required":["query"]}]},"_types.query_dsl:SimpleQueryStringFlags":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-simple-query-string-query.html#supported-flags"},"description":"Query flags can be either a single flag or a combination of flags, e.g. `OR|AND|PREFIX`","allOf":[{"$ref":"#/components/schemas/_spec_utils:PipeSeparatedFlagsSimpleQueryStringFlag"}]},"_spec_utils:PipeSeparatedFlagsSimpleQueryStringFlag":{"description":"A set of flags that can be represented as a single enum value or a set of values that are encoded\\nas a pipe-separated string\\n\\nDepending on the target language, code generators can use this hint to generate language specific\\nflags enum constructs and the corresponding (de-)serialization code.","oneOf":[{"$ref":"#/components/schemas/_types.query_dsl:SimpleQueryStringFlag"},{"type":"string"}]},"_types.query_dsl:SimpleQueryStringFlag":{"type":"string","enum":["NONE","AND","NOT","OR","PREFIX","PHRASE","PRECEDENCE","ESCAPE","WHITESPACE","FUZZY","NEAR","SLOP","ALL"]},"_types.query_dsl:SpanContainingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"big":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"little":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["big","little"]}]},"_types.query_dsl:SpanQuery":{"type":"object","properties":{"span_containing":{"$ref":"#/components/schemas/_types.query_dsl:SpanContainingQuery"},"field_masking_span":{"$ref":"#/components/schemas/_types.query_dsl:SpanFieldMaskingQuery"},"span_first":{"$ref":"#/components/schemas/_types.query_dsl:SpanFirstQuery"},"span_gap":{"$ref":"#/components/schemas/_types.query_dsl:SpanGapQuery"},"span_multi":{"$ref":"#/components/schemas/_types.query_dsl:SpanMultiTermQuery"},"span_near":{"$ref":"#/components/schemas/_types.query_dsl:SpanNearQuery"},"span_not":{"$ref":"#/components/schemas/_types.query_dsl:SpanNotQuery"},"span_or":{"$ref":"#/components/schemas/_types.query_dsl:SpanOrQuery"},"span_term":{"description":"The equivalent of the `term` query but for use with other span queries.","type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.query_dsl:SpanTermQuery"},"minProperties":1,"maxProperties":1},"span_within":{"$ref":"#/components/schemas/_types.query_dsl:SpanWithinQuery"}},"minProperties":1,"maxProperties":1},"_types.query_dsl:SpanFieldMaskingQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"query":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["field","query"]}]},"_types.query_dsl:SpanFirstQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"end":{"description":"Controls the maximum end position permitted in a match.","type":"number"},"match":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["end","match"]}]},"_types.query_dsl:SpanGapQuery":{"description":"Can only be used as a clause in a span_near query.","type":"object","additionalProperties":{"type":"number"},"minProperties":1,"maxProperties":1},"_types.query_dsl:SpanMultiTermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"match":{"$ref":"#/components/schemas/_types.query_dsl:QueryContainer"}},"required":["match"]}]},"_types.query_dsl:SpanNearQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"clauses":{"description":"Array of one or more other span type queries.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"in_order":{"description":"Controls whether matches are required to be in-order.","type":"boolean"},"slop":{"description":"Controls the maximum number of intervening unmatched positions permitted.","type":"number"}},"required":["clauses"]}]},"_types.query_dsl:SpanNotQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"dist":{"description":"The number of tokens from within the include span that can’t have overlap with the exclude span.\\nEquivalent to setting both `pre` and `post`.","type":"number"},"exclude":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"include":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"post":{"description":"The number of tokens after the include span that can’t have overlap with the exclude span.","type":"number"},"pre":{"description":"The number of tokens before the include span that can’t have overlap with the exclude span.","type":"number"}},"required":["exclude","include"]}]},"_types.query_dsl:SpanOrQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"clauses":{"description":"Array of one or more other span type queries.","type":"array","items":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}}},"required":["clauses"]}]},"_types.query_dsl:SpanTermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"type":"string"}},"required":["value"]}]},"_types.query_dsl:SpanWithinQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"big":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"},"little":{"$ref":"#/components/schemas/_types.query_dsl:SpanQuery"}},"required":["big","little"]}]},"_types.query_dsl:TermQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"$ref":"#/components/schemas/_types:FieldValue"},"case_insensitive":{"description":"Allows ASCII case insensitive matching of the value with the indexed field values when set to `true`.\\nWhen `false`, the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"}},"required":["value"]}]},"_types:FieldValue":{"description":"A field value.","oneOf":[{"type":"number"},{"type":"number"},{"type":"string"},{"type":"boolean"},{"nullable":true,"type":"string"},{"type":"object"}]},"_types.query_dsl:TermsQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object"}]},"_types.query_dsl:TermsSetQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"minimum_should_match_field":{"$ref":"#/components/schemas/_types:Field"},"minimum_should_match_script":{"$ref":"#/components/schemas/_types:Script"},"terms":{"description":"Array of terms you wish to find in the provided field.","type":"array","items":{"type":"string"}}},"required":["terms"]}]},"_types.query_dsl:TextExpansionQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"model_id":{"description":"The text expansion NLP model to use","type":"string"},"model_text":{"description":"The query text","type":"string"},"pruning_config":{"$ref":"#/components/schemas/_types.query_dsl:TokenPruningConfig"}},"required":["model_id","model_text"]}]},"_types.query_dsl:TokenPruningConfig":{"type":"object","properties":{"tokens_freq_ratio_threshold":{"description":"Tokens whose frequency is more than this threshold times the average frequency of all tokens in the specified field are considered outliers and pruned.","type":"number"},"tokens_weight_threshold":{"description":"Tokens whose weight is less than this threshold are considered nonsignificant and pruned.","type":"number"},"only_score_pruned_tokens":{"description":"Whether to only score pruned tokens, vs only scoring kept tokens.","type":"boolean"}}},"_types.query_dsl:WeightedTokensQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"tokens":{"description":"The tokens representing this query","type":"object","additionalProperties":{"type":"number"}},"pruning_config":{"$ref":"#/components/schemas/_types.query_dsl:TokenPruningConfig"}},"required":["tokens"]}]},"_types.query_dsl:WildcardQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"case_insensitive":{"description":"Allows case insensitive matching of the pattern with the indexed field values when set to true. Default is false which means the case sensitivity of matching depends on the underlying field’s mapping.","type":"boolean"},"rewrite":{"$ref":"#/components/schemas/_types:MultiTermQueryRewrite"},"value":{"description":"Wildcard pattern for terms you wish to find in the provided field. Required, when wildcard is not set.","type":"string"},"wildcard":{"description":"Wildcard pattern for terms you wish to find in the provided field. Required, when value is not set.","type":"string"}}}]},"_types.query_dsl:WrapperQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"query":{"description":"A base64 encoded query.\\nThe binary data format can be any of JSON, YAML, CBOR or SMILE encodings","type":"string"}},"required":["query"]}]},"_types.query_dsl:TypeQuery":{"allOf":[{"$ref":"#/components/schemas/_types.query_dsl:QueryBase"},{"type":"object","properties":{"value":{"type":"string"}},"required":["value"]}]},"_types.mapping:RuntimeFields":{"type":"object","additionalProperties":{"$ref":"#/components/schemas/_types.mapping:RuntimeField"}},"_types.mapping:RuntimeField":{"type":"object","properties":{"fetch_fields":{"description":"For type `lookup`","type":"array","items":{"$ref":"#/components/schemas/_types.mapping:RuntimeFieldFetchFields"}},"format":{"externalDocs":{"url":"https://www.elastic.co/guide/en/elasticsearch/reference/current/mapping-date-format.html"},"description":"A custom format for `date` type runtime fields.","type":"string"},"input_field":{"$ref":"#/components/schemas/_types:Field"},"target_field":{"$ref":"#/components/schemas/_types:Field"},"target_index":{"$ref":"#/components/schemas/_types:IndexName"},"script":{"$ref":"#/components/schemas/_types:Script"},"type":{"$ref":"#/components/schemas/_types.mapping:RuntimeFieldType"}},"required":["type"]},"_types.mapping:RuntimeFieldFetchFields":{"type":"object","properties":{"field":{"$ref":"#/components/schemas/_types:Field"},"format":{"type":"string"}},"required":["field"]},"_types.mapping:RuntimeFieldType":{"type":"string","enum":["boolean","composite","date","double","geo_point","ip","keyword","long","lookup"]},"_types:HttpHeaders":{"type":"object","additionalProperties":{"oneOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]}}}}}')},855:function(e,t,s){"use strict";s.r(t),s.d(t,"EditorComponent",(function(){return p}));var r=s(90),n=s(5),o=s(787),a=s(104),i=(s(2),s(6));const p=({value:e,onChange:t,readOnly:s})=>Object(i.jsx)(r.CodeEditor,{languageId:"json",height:500,languageConfiguration:{autoClosingPairs:[{open:"{",close:"}"}]},value:e,onChange:t,options:{ariaLabel:n.i18n.translate("xpack.ml.dataframe.analytics.create.advancedEditor.codeEditorAriaLabel",{defaultMessage:"Advanced analytics job editor"}),automaticLayout:!0,readOnly:s,fontSize:12,scrollBeyondLastLine:!1,quickSuggestions:!0,minimap:{enabled:!1},wordWrap:"on",wrappingIndent:"indent"},editorDidMount:e=>{var t,s;const r=null===(t=e.getModel())||void 0===t?void 0:t.uri.toString();a.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({validate:!0,enableSchemaRequest:!1,schemaValidation:"error",schemas:[...null!==(s=a.monaco.languages.json.jsonDefaults.diagnosticsOptions.schemas)&&void 0!==s?s:[],{uri:r,fileMatch:[r],schema:o}]})}})}}]);