/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.ml_bundle_jsonpfunction=window.ml_bundle_jsonpfunction||[]).push([[102],{894:function(e,t,l){"use strict";l.r(t),l.d(t,"AddModelFlyout",(function(){return b}));var s=l(25),d=l(15),o=l(2),a=l.n(o),n=l(8),i=l(5),c=l(6);const r=({supportedNlpModels:e,nlpImportModel:t})=>Object(c.jsx)(a.a.Fragment,null,Object(c.jsx)(s.EuiSpacer,{size:"m"}),Object(c.jsx)(s.EuiSteps,{steps:[{title:i.i18n.translate("xpack.ml.addInferenceEndpoint.elandPythonClient.step1Title",{defaultMessage:"Install the Eland Python Client"}),children:Object(c.jsx)(s.EuiText,null,Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.pipInstallLabel",defaultMessage:"Eland can be installed with {pipLink} from {pypiLink}:",values:{pipLink:Object(c.jsx)(s.EuiLink,{href:"https://pypi.org/project/pip/",target:"_blank",external:!0},"pip"),pypiLink:Object(c.jsx)(s.EuiLink,{href:"https://pypi.org/",target:"_blank",external:!0},"PyPI")}})),Object(c.jsx)(s.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandPipInstallCodeBlock"},Object(c.jsx)("p",null,"$ python -m pip install eland")),Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.condaInstallLabel",defaultMessage:"or it can also be installed with {condaLink} from {condaForgeLink}:",values:{condaLink:Object(c.jsx)(s.EuiLink,{href:"https://docs.conda.io/",target:"_blank",external:!0},"Conda"),condaForgeLink:Object(c.jsx)(s.EuiLink,{href:"https://conda-forge.org/",target:"_blank",external:!0},"Conda Forge")}})),Object(c.jsx)(s.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandCondaInstallCodeBlock"},Object(c.jsx)("p",null," $ conda install -c conda-forge eland")))},{title:i.i18n.translate("xpack.ml.addInferenceEndpoint.elandPythonClient.step2Title",{defaultMessage:"Importing your third-party model"}),children:Object(c.jsx)(s.EuiText,null,Object(c.jsx)("p",null,Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.step2Body",defaultMessage:"Follow the instructions on importing compatible third-party models"}))),Object(c.jsx)("p",null,Object(c.jsx)("b",null,Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.step2ExampleTitle",defaultMessage:"Example import"})),Object(c.jsx)(s.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandExampleImportCodeBlock"},"eland_import_hub_model ",Object(c.jsx)("br",null),"--cloud-id <cloud-id> \\ ",Object(c.jsx)("br",null),"-u <username> -p <password> \\ ",Object(c.jsx)("br",null),"--hub-model-id <model-id> \\ ",Object(c.jsx)("br",null),"--task-type ner \\")),Object(c.jsx)(s.EuiFlexGroup,{gutterSize:"s"},Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiButtonEmpty,{href:t,target:"_blank",iconType:"help"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.importModelButtonLabel",defaultMessage:"Import models with Eland"}))),Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiButtonEmpty,{href:e,target:"_blank",iconType:"help"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.compatibleModelsButtonLabel",defaultMessage:"Compatible NLP models"})))))},{title:i.i18n.translate("xpack.ml.addInferenceEndpoint.elandPythonClient.step4Title",{defaultMessage:"Deploy your model"}),children:Object(c.jsx)(a.a.Fragment,null,Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},Object(c.jsx)("p",null,Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.step4Body",defaultMessage:"Click “Start deployment” in the table row containing your new model to deploy and use it."}))),Object(c.jsx)(s.EuiSpacer,{size:"m"}),Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},Object(c.jsx)("p",null,Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.addInferenceEndpoint.elandPythonClient.step3Body",defaultMessage:"Note: The trained model list automatically refreshes with the most current imported models in your cluster. If the list is not updated, click the 'Refresh' button in the top right corner. Otherwise, revisit the instructions above to troubleshoot."}))))}]}));var u=l(70),j=l(10);const b=({onClose:e,onSubmit:t,modelDownloads:l})=>{const a=Object(u.usePermissionCheck)("canCreateTrainedModels")&&l.length>0,[n,i]=Object(o.useState)(a?"clickToDownload":"manualDownload"),r=Object(o.useMemo)((()=>[...a?[{id:"clickToDownload",name:Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.clickToDownloadTabLabel",defaultMessage:"Click to Download"}),content:Object(c.jsx)(m,{modelDownloads:l,onModelDownload:t})}]:[],{id:"manualDownload",name:Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.thirdPartyLabel",defaultMessage:"Manual Download"}),content:Object(c.jsx)(x,null)}]),[a,l,t]),j=Object(o.useMemo)((()=>{var e;return null===(e=r.find((e=>e.id===n)))||void 0===e?void 0:e.content}),[n,r]);return Object(c.jsx)(s.EuiFlyout,{ownFocus:!0,onClose:e,"aria-labelledby":"addTrainedModelFlyout","data-test-subj":"mlAddTrainedModelFlyout"},Object(c.jsx)(s.EuiFlyoutHeader,null,Object(c.jsx)(s.EuiTitle,{size:"m"},Object(c.jsx)("h2",{id:"addTrainedModelFlyout"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.title",defaultMessage:"Add a trained model"}))),Object(c.jsx)(s.EuiTabs,null,r.map((e=>Object(c.jsx)(s.EuiTab,{key:e.id,isSelected:n===e.id,onClick:i.bind(null,e.id),"data-test-subj":`mlAddTrainedModelFlyoutTab ${e.id}`},e.name))))),Object(c.jsx)(s.EuiFlyoutBody,null,j),Object(c.jsx)(s.EuiFlyoutFooter,null,Object(c.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween"},Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiButtonEmpty,{iconType:"cross",onClick:e,flush:"left"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.closeButtonLabel",defaultMessage:"Close"}))))))},m=({modelDownloads:e,onModelDownload:t})=>{var l;const{services:{docLinks:i}}=Object(j.d)(),[r,u]=Object(o.useState)(null===(l=e.find((e=>e.recommended)))||void 0===l?void 0:l.model_id);return Object(c.jsx)(a.a.Fragment,null,Object.entries(Object(n.groupBy)(e,"modelName")).map((([e,t])=>Object(c.jsx)(a.a.Fragment,{key:e},"elser"===e?Object(c.jsx)("div",null,Object(c.jsx)(s.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiIcon,{type:"logoElastic",size:"l"})),Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiTitle,{size:"s"},Object(c.jsx)("h3",null,Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserTitle",defaultMessage:"ELSER (Elastic Learned Sparse EncodeR)"}))))),Object(c.jsx)(s.EuiSpacer,{size:"s"}),Object(c.jsx)("p",null,Object(c.jsx)(s.EuiText,{color:"subdued",size:"s","data-test-subj":"mlAddTrainedModelFlyoutElserModelHeaderCopy"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elserDescription",defaultMessage:"ELSER is Elastic's NLP model for English semantic search, utilizing sparse vectors. It prioritizes intent and contextual meaning over literal term matching, optimized specifically for English documents and queries on the Elastic platform."}))),Object(c.jsx)(s.EuiSpacer,{size:"s"}),Object(c.jsx)("p",null,Object(c.jsx)(s.EuiLink,{href:i.links.ml.nlpElser,external:!0,target:"_blank"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",defaultMessage:"View documentation"}))),Object(c.jsx)(s.EuiSpacer,{size:"m"})):null,"e5"===e?Object(c.jsx)("div",null,Object(c.jsx)(s.EuiTitle,{size:"s"},Object(c.jsx)("h3",null,Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.e5Title",defaultMessage:"E5 (EmbEddings from bidirEctional Encoder rEpresentations)"}))),Object(c.jsx)(s.EuiSpacer,{size:"s"}),Object(c.jsx)("p",null,Object(c.jsx)(s.EuiText,{color:"subdued",size:"s"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.e5Description",defaultMessage:"E5 is a third party NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries."}))),Object(c.jsx)(s.EuiSpacer,{size:"s"}),Object(c.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween",gutterSize:"none"},Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiLink,{href:i.links.ml.nlpE5,external:!0,target:"_blank"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",defaultMessage:"View documentation"})))),Object(c.jsx)(s.EuiSpacer,{size:"l"})):null,Object(c.jsx)(s.EuiFormFieldset,{legend:{children:Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.chooseModelLabel",defaultMessage:"Choose a model"})}},t.map(((l,o)=>Object(c.jsx)(a.a.Fragment,{key:l.model_id},Object(c.jsx)(s.EuiCheckableCard,{id:l.model_id,label:Object(c.jsx)(s.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"spaceBetween","data-test-subj":"mlAddTrainedModelFlyoutChooseModelPanels"},Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)("header",null,Object(c.jsx)(s.EuiText,{size:"s"},Object(c.jsx)("b",null,"Linux"===l.os&&"amd64"===l.arch?Object(c.jsx)("div",{"data-test-subj":`mlAddTrainedModelFlyoutModelPanel-${e}-${l.model_id}`},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.intelLinuxLabel",defaultMessage:"Intel and Linux optimized"})):Object(c.jsx)("div",{"data-test-subj":`mlAddTrainedModelFlyoutModelPanel-${e}-${l.model_id}`},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.crossPlatformLabel",defaultMessage:"Cross platform"}))))),Object(c.jsx)(s.EuiText,{size:"s",color:"subdued"},l.model_id)),Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},l.recommended?Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiToolTip,{content:Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.recommendedDownloadContent",defaultMessage:"Recommended model version for your cluster's hardware configuration"})},Object(c.jsx)(s.EuiBadge,{color:"hollow"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.recommendedDownloadLabel",defaultMessage:"Recommended"})))):null,l.licenseUrl&&l.softwareLicense?Object(c.jsx)(s.EuiFlexItem,{grow:!1},Object(c.jsx)(s.EuiBadge,{color:"hollow",target:"_blank",href:l.licenseUrl},"MIT"===l.softwareLicense?Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.mitLicenseLabel",defaultMessage:"License: MIT"}):null)):null))),name:l.model_id,value:l.model_id,checked:l.model_id===r,onChange:u.bind(null,l.model_id)}),o<t.length-1?Object(c.jsx)(s.EuiSpacer,{size:"m"}):null)))),Object(c.jsx)(s.EuiSpacer,{size:"xxl"})))),Object(c.jsx)(s.EuiButton,{onClick:t.bind(null,r),fill:!0,disabled:!r,"data-test-subj":"mlAddTrainedModelFlyoutDownloadButton"},Object(c.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.downloadButtonLabel",defaultMessage:"Download"})))},x=()=>{const{services:{docLinks:e}}=Object(j.d)();return Object(c.jsx)(r,{supportedNlpModels:e.links.enterpriseSearch.supportedNlpModels,nlpImportModel:e.links.ml.nlpImportModel})}}}]);