"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrainedModelsProvider = getTrainedModelsProvider;
var _model_management = require("../../models/model_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTrainedModelsProvider(getGuards, cloud) {
  return {
    trainedModelsProvider(request, savedObjectsClient) {
      const guards = getGuards(request, savedObjectsClient);
      return {
        async getTrainedModels(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.getTrainedModels(params);
          });
        },
        async getTrainedModelsStats(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.getTrainedModelsStats(params);
          });
        },
        async startTrainedModelDeployment(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canStartStopTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.startTrainedModelDeployment(params);
          });
        },
        async stopTrainedModelDeployment(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canStartStopTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.stopTrainedModelDeployment(params);
          });
        },
        async inferTrainedModel(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.inferTrainedModel(params);
          });
        },
        async deleteTrainedModel(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canDeleteTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.deleteTrainedModel(params);
          });
        },
        async updateTrainedModelDeployment(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canCreateTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.updateTrainedModelDeployment(params);
          });
        },
        async putTrainedModel(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canCreateTrainedModels']).ok(async ({
            mlClient
          }) => {
            return mlClient.putTrainedModel(params);
          });
        },
        async getELSER(params) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            scopedClient,
            mlClient
          }) => {
            return (0, _model_management.modelsProvider)(scopedClient, mlClient, cloud).getELSER(params);
          });
        },
        async getCuratedModelConfig(...params) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            scopedClient,
            mlClient
          }) => {
            return (0, _model_management.modelsProvider)(scopedClient, mlClient, cloud).getCuratedModelConfig(...params);
          });
        },
        async installElasticModel(modelId) {
          return await guards.isFullLicense().hasMlCapabilities(['canGetTrainedModels']).ok(async ({
            scopedClient,
            mlClient,
            mlSavedObjectService
          }) => {
            return (0, _model_management.modelsProvider)(scopedClient, mlClient, cloud).installElasticModel(modelId, mlSavedObjectService);
          });
        }
      };
    }
  };
}