"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateTrainedModelsSpaces = exports.updateJobsSpaces = exports.syncJobObjects = exports.syncCheckSchema = exports.jobTypeSchema = exports.jobTypeLiterals = exports.itemsAndCurrentSpace = exports.itemTypeSchema = exports.itemTypeLiterals = exports.canDeleteMLSpaceAwareItemsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobTypeLiterals = exports.jobTypeLiterals = _configSchema.schema.oneOf([_configSchema.schema.literal('anomaly-detector'), _configSchema.schema.literal('data-frame-analytics')]);
const itemTypeLiterals = exports.itemTypeLiterals = _configSchema.schema.oneOf([_configSchema.schema.literal('anomaly-detector'), _configSchema.schema.literal('data-frame-analytics'), _configSchema.schema.literal('trained-model')]);
const itemTypeSchema = exports.itemTypeSchema = _configSchema.schema.object({
  jobType: itemTypeLiterals
});
const jobTypeSchema = exports.jobTypeSchema = _configSchema.schema.object({
  jobType: jobTypeLiterals
});
const updateJobsSpaces = exports.updateJobsSpaces = _configSchema.schema.object({
  jobType: jobTypeLiterals,
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  spacesToAdd: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  spacesToRemove: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const updateTrainedModelsSpaces = exports.updateTrainedModelsSpaces = _configSchema.schema.object({
  modelIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  spacesToAdd: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  spacesToRemove: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const itemsAndCurrentSpace = exports.itemsAndCurrentSpace = _configSchema.schema.object({
  mlSavedObjectType: itemTypeLiterals,
  ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const syncJobObjects = exports.syncJobObjects = _configSchema.schema.object({
  simulate: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const syncCheckSchema = exports.syncCheckSchema = _configSchema.schema.object({
  mlSavedObjectType: _configSchema.schema.maybe(_configSchema.schema.string())
});
const canDeleteMLSpaceAwareItemsSchema = exports.canDeleteMLSpaceAwareItemsSchema = _configSchema.schema.object({
  /** List of job or trained model IDs. */
  ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});