"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDeploymentParamsSchema = exports.threadingParamsSchema = exports.stopDeploymentSchema = exports.putTrainedModelQuerySchema = exports.pipelineSimulateBody = exports.pipelineDocs = exports.optionalModelIdSchema = exports.modelIdSchema = exports.modelDownloadsQuery = exports.modelAndDeploymentIdSchema = exports.inferTrainedModelQuery = exports.inferTrainedModelBody = exports.getInferenceQuerySchema = exports.deleteTrainedModelQuerySchema = exports.curatedModelsQuerySchema = exports.curatedModelsParamsSchema = exports.createIngestPipelineSchema = exports.createInferenceSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const modelIdSchema = exports.modelIdSchema = _configSchema.schema.object({
  /**
   * Model ID
   */
  modelId: _configSchema.schema.string()
});
const modelAndDeploymentIdSchema = exports.modelAndDeploymentIdSchema = _configSchema.schema.object({
  /**
   * Model ID
   */
  modelId: _configSchema.schema.string(),
  /**
   * Deployment ID
   */
  deploymentId: _configSchema.schema.string()
});
const createInferenceSchema = exports.createInferenceSchema = _configSchema.schema.object({
  taskType: _configSchema.schema.oneOf([_configSchema.schema.literal('sparse_embedding'), _configSchema.schema.literal('text_embedding')]),
  inferenceId: _configSchema.schema.string()
});
const threadingParamsSchema = exports.threadingParamsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  number_of_allocations: _configSchema.schema.maybe(_configSchema.schema.number()),
  threads_per_allocation: _configSchema.schema.maybe(_configSchema.schema.number()),
  priority: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('low'), _configSchema.schema.literal('normal')])),
  deployment_id: _configSchema.schema.maybe(_configSchema.schema.string())
}));
const updateDeploymentParamsSchema = exports.updateDeploymentParamsSchema = _configSchema.schema.object({
  number_of_allocations: _configSchema.schema.number()
});
const optionalModelIdSchema = exports.optionalModelIdSchema = _configSchema.schema.object({
  /**
   * Model ID
   */
  modelId: _configSchema.schema.maybe(_configSchema.schema.string())
});
const getInferenceQuerySchema = exports.getInferenceQuerySchema = _configSchema.schema.object({
  size: _configSchema.schema.maybe(_configSchema.schema.string()),
  with_pipelines: _configSchema.schema.maybe(_configSchema.schema.string()),
  with_indices: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean()])),
  include: _configSchema.schema.maybe(_configSchema.schema.string())
});
const putTrainedModelQuerySchema = exports.putTrainedModelQuerySchema = _configSchema.schema.object({
  defer_definition_decompression: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const inferTrainedModelQuery = exports.inferTrainedModelQuery = _configSchema.schema.object({
  timeout: _configSchema.schema.maybe(_configSchema.schema.string())
});
const inferTrainedModelBody = exports.inferTrainedModelBody = _configSchema.schema.object({
  docs: _configSchema.schema.any(),
  inference_config: _configSchema.schema.maybe(_configSchema.schema.any())
});
const pipelineSimulateBody = exports.pipelineSimulateBody = _configSchema.schema.object({
  pipeline: _configSchema.schema.any(),
  docs: _configSchema.schema.arrayOf(_configSchema.schema.any())
});
const pipelineDocs = exports.pipelineDocs = _configSchema.schema.arrayOf(_configSchema.schema.string());
const stopDeploymentSchema = exports.stopDeploymentSchema = _configSchema.schema.object({
  modelId: _configSchema.schema.string(),
  /** force stop */
  force: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const deleteTrainedModelQuerySchema = exports.deleteTrainedModelQuerySchema = _configSchema.schema.object({
  with_pipelines: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false
  })),
  force: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false
  }))
});
const createIngestPipelineSchema = exports.createIngestPipelineSchema = _configSchema.schema.object({
  pipelineName: _configSchema.schema.string(),
  pipeline: _configSchema.schema.maybe(_configSchema.schema.object({
    processors: _configSchema.schema.arrayOf(_configSchema.schema.any()),
    description: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const modelDownloadsQuery = exports.modelDownloadsQuery = _configSchema.schema.object({
  version: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('1'), _configSchema.schema.literal('2')]))
});
const curatedModelsParamsSchema = exports.curatedModelsParamsSchema = _configSchema.schema.object({
  modelName: _configSchema.schema.string()
});
const curatedModelsQuerySchema = exports.curatedModelsQuerySchema = _configSchema.schema.object({
  version: _configSchema.schema.maybe(_configSchema.schema.number())
});