"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceModelRoutes = inferenceModelRoutes;
var _configSchema = require("@kbn/config-schema");
var _inference_schema = require("./schemas/inference_schema");
var _model_management = require("../models/model_management");
var _error_wrapper = require("../client/error_wrapper");
var _app = require("../../common/constants/app");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function inferenceModelRoutes({
  router,
  routeGuard
}, cloud) {
  /**
   * @apiGroup TrainedModels
   *
   * @api {put} /internal/ml/_inference/:taskType/:inferenceId Create Inference Endpoint
   * @apiName CreateInferenceEndpoint
   * @apiDescription Create Inference Endpoint
   */
  router.versioned.put({
    path: `${_app.ML_INTERNAL_BASE_PATH}/_inference/{taskType}/{inferenceId}`,
    access: 'internal',
    options: {
      tags: ['access:ml:canCreateInferenceEndpoint']
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: _inference_schema.createInferenceSchema,
        body: _configSchema.schema.maybe(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))
      }
    }
  }, routeGuard.fullLicenseAPIGuard(async ({
    client,
    mlClient,
    request,
    response,
    mlSavedObjectService
  }) => {
    try {
      const {
        inferenceId,
        taskType
      } = request.params;
      const body = await (0, _model_management.modelsProvider)(client, mlClient, cloud).createInferenceEndpoint(inferenceId, taskType, request.body);
      const {
        syncSavedObjects
      } = (0, _saved_objects.syncSavedObjectsFactory)(client, mlSavedObjectService);
      await syncSavedObjects(false);
      return response.ok({
        body
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
  /**
   * @apiGroup TrainedModels
   *
   * @api {put} /internal/ml/_inference/:taskType/:inferenceId Create Inference Endpoint
   * @apiName CreateInferenceEndpoint
   * @apiDescription Create Inference Endpoint
   */
  router.versioned.get({
    path: `${_app.ML_INTERNAL_BASE_PATH}/_inference/all`,
    access: 'internal',
    options: {
      tags: ['access:ml:canGetTrainedModels']
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, routeGuard.fullLicenseAPIGuard(async ({
    client,
    response
  }) => {
    try {
      const body = await client.asCurrentUser.transport.request({
        method: 'GET',
        path: `/_inference/_all`
      });
      return response.ok({
        body
      });
    } catch (e) {
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  }));
}