"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "InsufficientMLCapabilities", {
  enumerable: true,
  get: function () {
    return _shared.InsufficientMLCapabilities;
  }
});
Object.defineProperty(exports, "MLPrivilegesUninitialized", {
  enumerable: true,
  get: function () {
    return _shared.MLPrivilegesUninitialized;
  }
});
Object.defineProperty(exports, "UnknownMLCapabilitiesError", {
  enumerable: true,
  get: function () {
    return _shared.UnknownMLCapabilitiesError;
  }
});
exports.plugin = exports.config = void 0;
var _config_schema = require("./config_schema");
var _shared = require("./shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const config = exports.config = {
  schema: _config_schema.configSchema,
  exposeToBrowser: {
    ad: true,
    dfa: true,
    nlp: true,
    experimental: true
  }
};
const plugin = async ctx => {
  const {
    MlServerPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new MlServerPlugin(ctx);
};
exports.plugin = plugin;