"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SWIMLANE_PANEL_ACTION = void 0;
exports.createAddSwimlanePanelAction = createAddSwimlanePanelAction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _app = require("../../common/constants/app");
var _embeddables = require("../embeddables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_SWIMLANE_PANEL_ACTION = exports.EDIT_SWIMLANE_PANEL_ACTION = 'editSwimlanePanelAction';
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddSwimlanePanelAction(getStartServices) {
  return {
    id: 'create-anomaly-swimlane',
    grouping: [{
      id: _app.PLUGIN_ID,
      getDisplayName: () => _app.ML_APP_NAME,
      getIconType: () => _app.PLUGIN_ICON
    }],
    order: 40,
    // @ts-expect-error getIconType is typed as string, but EuiIcon accepts ReactComponent for custom icons.
    // See https://github.com/elastic/kibana/issues/184643
    getIconType: () => iconProps => /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
      width: "16",
      height: "16",
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg"
    }, iconProps), /*#__PURE__*/_react.default.createElement("path", {
      d: "M1 5V1H5V5H1ZM4 4V2H2V4H4ZM6 5V1H10V5H6ZM9 4V2H7V4H9ZM11 5V1H15V5H11ZM12 4H14V2H12V4ZM1 10V6H5V10H1ZM4 9V7H2V9H4ZM6 10V6H10V10H6ZM9 9V7H7V9H9ZM11 10V6H15V10H11ZM14 9V7H12V9H14ZM1 15V11H5V15H1ZM2 14H4V12H2V14ZM6 15V11H10V15H6ZM7 14H9V12H7V14ZM11 15V11H15V15H11ZM12 14H14V12H12V14Z",
      fill: "currentColor"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      width: "4",
      height: "4",
      transform: "translate(6 1)",
      fill: "currentColor"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      width: "4",
      height: "4",
      transform: "translate(11 6)",
      fill: "currentColor"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      width: "4",
      height: "4",
      transform: "translate(6 6)",
      fill: "currentColor"
    }), /*#__PURE__*/_react.default.createElement("rect", {
      width: "4",
      height: "4",
      transform: "translate(1 11)",
      fill: "currentColor"
    })),
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.components.jobAnomalyScoreEmbeddable.displayName', {
      defaultMessage: 'Anomaly swim lane'
    }),
    getDisplayNameTooltip: () => _i18n.i18n.translate('xpack.ml.components.jobAnomalyScoreEmbeddable.description', {
      defaultMessage: 'View anomaly detection results in a timeline.'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      const [coreStart, pluginStart] = await getStartServices();
      try {
        const {
          resolveAnomalySwimlaneUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/anomaly_swimlane/anomaly_swimlane_setup_flyout')));
        const initialState = await resolveAnomalySwimlaneUserInput({
          ...coreStart,
          ...pluginStart
        }, context.embeddable, context.embeddable.uuid);
        presentationContainerParent.addNewPanel({
          panelType: _embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE,
          initialState: {
            ...initialState,
            title: initialState.panelTitle
          }
        });
      } catch (e) {
        return Promise.reject();
      }
    }
  };
}