"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddSingleMetricViewerPanelAction = createAddSingleMetricViewerPanelAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _http_service = require("../application/services/http_service");
var _app = require("../../common/constants/app");
var _embeddables = require("../embeddables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddSingleMetricViewerPanelAction(getStartServices) {
  // @ts-ignore
  return {
    id: 'create-single-metric-viewer',
    grouping: [{
      id: _app.PLUGIN_ID,
      getDisplayName: () => _app.ML_APP_NAME,
      getIconType: () => _app.PLUGIN_ICON
    }],
    order: 20,
    getIconType: () => 'visLine',
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.components.singleMetricViewerEmbeddable.displayName', {
      defaultMessage: 'Single metric viewer'
    }),
    getDisplayNameTooltip: () => _i18n.i18n.translate('xpack.ml.components.singleMetricViewerEmbeddable.description', {
      defaultMessage: 'View anomaly detection results for a single metric on a focused date range.'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      const [coreStart, {
        data,
        share
      }] = await getStartServices();
      try {
        const {
          resolveEmbeddableSingleMetricViewerUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/single_metric_viewer/single_metric_viewer_setup_flyout')));
        const {
          mlApiServicesProvider
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service')));
        const httpService = new _http_service.HttpService(coreStart.http);
        const mlApiServices = mlApiServicesProvider(httpService);
        const initialState = await resolveEmbeddableSingleMetricViewerUserInput(coreStart, context.embeddable, context.embeddable.uuid, {
          data,
          share
        }, mlApiServices);
        presentationContainerParent.addNewPanel({
          panelType: _embeddables.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE,
          initialState: {
            ...initialState,
            title: initialState.panelTitle
          }
        });
      } catch (e) {
        return Promise.reject();
      }
    }
  };
}