"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("@kbn/data-plugin/common");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _moment = require("moment");
var _lodash = require("lodash");
var _timeseriesexplorer_embeddable_chart = require("../../application/timeseriesexplorer/timeseriesexplorer_embeddable_chart");
var _timeseriesexplorer_constants = require("../../application/timeseriesexplorer/timeseriesexplorer_constants");
require("./_index.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerPadding = 10;
const minElemAndChartDiff = 20;
const RESIZE_THROTTLE_TIME_MS = 500;
const errorMessage = _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.errorMessage"', {
  defaultMessage: 'Unable to load the ML single metric viewer data'
});

/**
 * Only used to initialize internally
 */

const SingleMetricViewerWrapper = ({
  // Component dependencies
  coreStart,
  pluginStart,
  mlServices,
  // Component props
  bounds,
  functionDescription,
  lastRefresh,
  onError,
  onRenderComplete,
  selectedDetectorIndex,
  selectedEntities,
  selectedJobId,
  uuid
}) => {
  const [chartDimensions, setChartDimensions] = (0, _react.useState)({
    width: 0,
    height: 0
  });
  const [zoom, setZoom] = (0, _react.useState)();
  const [selectedForecastId, setSelectedForecastId] = (0, _react.useState)();
  const [selectedJob, setSelectedJob] = (0, _react.useState)();
  const [jobsLoaded, setJobsLoaded] = (0, _react.useState)(false);
  const isMounted = (0, _useMountedState.default)();
  const {
    mlApiServices,
    mlJobService,
    mlTimeSeriesExplorerService,
    toastNotificationService
  } = mlServices;
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme');
  const datePickerDeps = {
    ...(0, _lodash.pick)(coreStart, ['http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    data: pluginStart.data,
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice: false
  };
  const previousRefresh = (0, _usePrevious.default)(lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0);
  (0, _react.useEffect)(function setUpJobsLoaded() {
    async function loadJobs() {
      try {
        await mlJobService.loadJobsWrapper();
        setJobsLoaded(true);
      } catch (e) {
        if (onError) {
          onError(new Error(errorMessage));
        }
      }
    }
    if (isMounted() === false) {
      return;
    }
    loadJobs();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isMounted]);
  (0, _react.useEffect)(function setUpSelectedJob() {
    async function fetchSelectedJob() {
      if (mlApiServices && selectedJobId !== undefined) {
        try {
          const {
            jobs
          } = await mlApiServices.getJobs({
            jobId: selectedJobId
          });
          const job = jobs[0];
          setSelectedJob(job);
        } catch (e) {
          if (onError) {
            onError(new Error(errorMessage));
          }
        }
      }
    }
    if (isMounted() === false) {
      return;
    }
    fetchSelectedJob();
  }, [selectedJobId, mlApiServices, isMounted, onError]);
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    if (Math.abs(chartDimensions.width - e.width) > minElemAndChartDiff || Math.abs(chartDimensions.height - e.height) > minElemAndChartDiff) {
      setChartDimensions(e);
    }
  }, RESIZE_THROTTLE_TIME_MS), [chartDimensions.width, chartDimensions.height]);
  const autoZoomDuration = (0, _react.useMemo)(() => {
    if (!selectedJob) return;
    return mlTimeSeriesExplorerService === null || mlTimeSeriesExplorerService === void 0 ? void 0 : mlTimeSeriesExplorerService.getAutoZoomDuration(selectedJob);
  }, [mlTimeSeriesExplorerService, selectedJob]);
  const appStateHandler = (0, _react.useCallback)((action, payload) => {
    /**
     * Empty zoom indicates that chart hasn't been rendered yet,
     * hence any updates prior that should replace the URL state.
     */
    switch (action) {
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_FORECAST_ID:
        setSelectedForecastId(payload);
        setZoom(undefined);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_ZOOM:
        setZoom(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.UNSET_ZOOM:
        setZoom(undefined);
        break;
    }
  }, [setZoom, setSelectedForecastId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlSingleMetricViewerEmbeddableWrapper-${uuid}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px'
    },
    "data-test-subj": `mlSingleMetricViewer_${uuid}`,
    ref: resizeRef,
    className: "ml-time-series-explorer",
    "data-shared-item": "" // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376
    ,
    "data-rendering-count": 1
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      mlServices: {
        ...mlServices
      },
      ...coreStart,
      ...pluginStart
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, selectedJobId !== undefined && autoZoomDuration !== undefined && jobsLoaded && selectedJobId === (selectedJob === null || selectedJob === void 0 ? void 0 : selectedJob.job_id) && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_embeddable_chart.TimeSeriesExplorerEmbeddableChart, {
    chartWidth: chartDimensions.width - containerPadding,
    chartHeight: chartDimensions.height - containerPadding,
    dataViewsService: pluginStart.data.dataViews,
    toastNotificationService: toastNotificationService,
    appStateHandler: appStateHandler,
    autoZoomDuration: autoZoomDuration,
    bounds: bounds,
    dateFormatTz: _moment.tz.guess(),
    lastRefresh: lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0,
    previousRefresh: previousRefresh,
    selectedJobId: selectedJobId,
    selectedDetectorIndex: selectedDetectorIndex,
    selectedEntities: selectedEntities,
    selectedForecastId: selectedForecastId,
    tableInterval: "auto",
    tableSeverity: 0,
    zoom: zoom,
    functionDescription: functionDescription,
    selectedJob: selectedJob,
    onRenderComplete: onRenderComplete
  }))))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SingleMetricViewerWrapper;
module.exports = exports.default;