"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSingleMetricViewerEmbeddableFactory = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _ = require("..");
var _single_metric_viewer_controls_initializer = require("./single_metric_viewer_controls_initializer");
var _single_metric_viewer_data_fetcher = require("./single_metric_viewer_data_fetcher");
var _get_services = require("./get_services");
var _use_embeddable_execution_context = require("../common/use_embeddable_execution_context");
var _single_metric_viewer = require("../../shared_components/single_metric_viewer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSingleMetricViewerEmbeddableFactory = getStartServices => {
  const factory = {
    type: _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE,
    deserializeState: state => state.rawState,
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      const services = await (0, _get_services.getServices)(getStartServices);
      const subscriptions = new _rxjs.Subscription();
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(state);
      const {
        api: timeRangeApi,
        comparators: timeRangeComparators,
        serialize: serializeTimeRange
      } = (0, _presentationPublishing.initializeTimeRange)(state);
      const {
        singleMetricViewerControlsApi,
        serializeSingleMetricViewerState,
        singleMetricViewerComparators,
        onSingleMetricViewerDestroy
      } = (0, _single_metric_viewer_controls_initializer.initializeSingleMetricViewerControls)(state, titlesApi);
      const dataLoading = new _rxjs.BehaviorSubject(true);
      const blockingError = new _rxjs.BehaviorSubject(undefined);
      const api = buildApi({
        isEditingEnabled: () => true,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.typeDisplayName', {
          defaultMessage: 'single metric viewer'
        }),
        onEdit: async () => {
          try {
            const {
              resolveEmbeddableSingleMetricViewerUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./single_metric_viewer_setup_flyout')));
            const [coreStart, {
              data,
              share
            }, {
              mlApiServices
            }] = services;
            const result = await resolveEmbeddableSingleMetricViewerUserInput(coreStart, parentApi, uuid, {
              data,
              share
            }, mlApiServices, {
              ...serializeTitles(),
              ...serializeSingleMetricViewerState()
            });
            singleMetricViewerControlsApi.updateUserInput(result);
          } catch (e) {
            return Promise.reject();
          }
        },
        ...titlesApi,
        ...timeRangeApi,
        ...singleMetricViewerControlsApi,
        dataLoading,
        blockingError,
        serializeState: () => {
          return {
            rawState: {
              timeRange: undefined,
              ...serializeTitles(),
              ...serializeTimeRange(),
              ...serializeSingleMetricViewerState()
            },
            references: []
          };
        }
      }, {
        ...timeRangeComparators,
        ...titleComparators,
        ...singleMetricViewerComparators
      });
      const {
        singleMetricViewerData$,
        onDestroy
      } = (0, _single_metric_viewer_data_fetcher.initializeSingleMetricViewerDataFetcher)(api, dataLoading, blockingError, services[1].data.query.timefilter.timefilter);
      const SingleMetricViewerComponent = (0, _single_metric_viewer.getSingleMetricViewerComponent)(...services);
      return {
        api,
        Component: () => {
          var _singleMetricViewerDa;
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          const {
            singleMetricViewerData,
            bounds,
            lastRefresh
          } = (0, _presentationPublishing.useStateFromPublishingSubject)(singleMetricViewerData$);
          (0, _use_embeddable_execution_context.useReactEmbeddableExecutionContext)(services[0].executionContext, parentApi.executionContext, _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE, uuid);
          (0, _useUnmount.default)(() => {
            onSingleMetricViewerDestroy();
            onDestroy();
            subscriptions.unsubscribe();
          });

          // Need to make sure we fall back to `undefined` if `functionDescription` is an empty string,
          // otherwise anomaly table data will not be loaded.
          const functionDescription = ((_singleMetricViewerDa = singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.functionDescription) !== null && _singleMetricViewerDa !== void 0 ? _singleMetricViewerDa : '') === '' ? undefined : singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.functionDescription;
          return /*#__PURE__*/_react.default.createElement(SingleMetricViewerComponent, {
            bounds: bounds,
            functionDescription: functionDescription,
            lastRefresh: lastRefresh,
            onError: error => blockingError.next(error),
            selectedDetectorIndex: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.selectedDetectorIndex,
            selectedEntities: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.selectedEntities,
            selectedJobId: singleMetricViewerData === null || singleMetricViewerData === void 0 ? void 0 : singleMetricViewerData.jobIds[0],
            uuid: api.uuid,
            onRenderComplete: () => {
              dataLoading.next(false);
            }
          });
        }
      };
    }
  };
  return factory;
};
exports.getSingleMetricViewerEmbeddableFactory = getSingleMetricViewerEmbeddableFactory;