"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSingleMetricViewerControls = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeSingleMetricViewerControls = (rawState, titlesApi) => {
  var _rawState$selectedDet;
  const functionDescription = new _rxjs.BehaviorSubject(rawState.functionDescription);
  const jobIds = new _rxjs.BehaviorSubject(rawState.jobIds);
  const selectedDetectorIndex = new _rxjs.BehaviorSubject((_rawState$selectedDet = rawState.selectedDetectorIndex) !== null && _rawState$selectedDet !== void 0 ? _rawState$selectedDet : 0);
  const selectedEntities = new _rxjs.BehaviorSubject(rawState.selectedEntities);
  const updateUserInput = update => {
    jobIds.next(update.jobIds);
    functionDescription.next(update.functionDescription);
    selectedDetectorIndex.next(update.selectedDetectorIndex);
    selectedEntities.next(update.selectedEntities);
    titlesApi.setPanelTitle(update.panelTitle);
  };
  const serializeSingleMetricViewerState = () => {
    return {
      jobIds: jobIds.value,
      selectedDetectorIndex: selectedDetectorIndex.value,
      selectedEntities: selectedEntities.value,
      functionDescription: functionDescription === null || functionDescription === void 0 ? void 0 : functionDescription.value
    };
  };
  const singleMetricViewerComparators = {
    jobIds: [jobIds, ids => jobIds.next(ids), _fastDeepEqual.default],
    selectedDetectorIndex: [selectedDetectorIndex, index => selectedDetectorIndex.next(index)],
    selectedEntities: [selectedEntities, items => selectedEntities.next(items), _fastDeepEqual.default],
    functionDescription: [functionDescription, description => functionDescription.next(description)]
  };
  return {
    singleMetricViewerControlsApi: {
      jobIds,
      selectedDetectorIndex,
      selectedEntities,
      functionDescription,
      updateUserInput
    },
    serializeSingleMetricViewerState,
    singleMetricViewerComparators,
    onSingleMetricViewerDestroy: () => {
      jobIds.complete();
      selectedDetectorIndex.complete();
      selectedEntities.complete();
      functionDescription.complete();
    }
  };
};
exports.initializeSingleMetricViewerControls = initializeSingleMetricViewerControls;