"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServices = exports.getMlServices = void 0;
var _http_service = require("../../application/services/http_service");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Provides the ML services required by the Single Metric Viewer Embeddable.
 */
const getMlServices = async (coreStart, pluginsStart) => {
  const [{
    AnomalyDetectorService
  }, {
    fieldFormatServiceFactory
  }, {
    indexServiceFactory
  }, {
    timeSeriesExplorerServiceFactory
  }, {
    mlApiServicesProvider
  }, {
    mlJobServiceFactory
  }, {
    mlResultsServiceProvider
  }, {
    MlCapabilitiesService
  }, {
    timeSeriesSearchServiceFactory
  }, {
    toastNotificationServiceProvider
  }] = await Promise.all([await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/field_format_service_factory'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/util/index_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/util/time_series_explorer_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/job_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/results_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/capabilities/check_capabilities'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/timeseriesexplorer/timeseriesexplorer_utils/time_series_search_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/toast_notification_service')))]);
  const httpService = new _http_service.HttpService(coreStart.http);
  const anomalyDetectorService = new AnomalyDetectorService(httpService);
  const mlApiServices = mlApiServicesProvider(httpService);
  const toastNotificationService = toastNotificationServiceProvider(coreStart.notifications.toasts);
  const mlJobService = mlJobServiceFactory(toastNotificationService, mlApiServices);
  const mlResultsService = mlResultsServiceProvider(mlApiServices);
  const mlTimeSeriesSearchService = timeSeriesSearchServiceFactory(mlResultsService, mlApiServices);
  const mlTimeSeriesExplorerService = timeSeriesExplorerServiceFactory(coreStart.uiSettings, mlApiServices, mlResultsService);
  const mlCapabilities = new MlCapabilitiesService(mlApiServices);
  const anomalyExplorerService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(pluginsStart.data.query.timefilter.timefilter, mlApiServices, mlResultsService);
  // Note on the following services:
  // - `mlIndexUtils` is just instantiated here to be passed on to `mlFieldFormatService`,
  //   but it's not being made available as part of global services. Since it's just
  //   some stateless utils `useMlIndexUtils()` should be used from within components.
  // - `mlFieldFormatService` is a stateful legacy service that relied on "dependency cache",
  //   so because of its own state it needs to be made available as a global service.
  //   In the long run we should again try to get rid of it here and make it available via
  //   its own context or possibly without having a singleton like state at all, since the
  //   way this manages its own state right now doesn't consider React component lifecycles.
  const mlIndexUtils = indexServiceFactory(pluginsStart.data.dataViews);
  const mlFieldFormatService = fieldFormatServiceFactory(mlApiServices, mlIndexUtils);
  return {
    anomalyDetectorService,
    anomalyExplorerService,
    mlApiServices,
    mlCapabilities,
    mlFieldFormatService,
    mlJobService,
    mlResultsService,
    mlTimeSeriesSearchService,
    mlTimeSeriesExplorerService,
    toastNotificationService
  };
};

/**
 * Provides the services required by the Single Metric Viewer Embeddable.
 */
exports.getMlServices = getMlServices;
const getServices = async getStartServices => {
  const [coreStart, pluginsStart] = await getStartServices();
  const mlServices = await getMlServices(coreStart, pluginsStart);
  return [coreStart, pluginsStart, mlServices];
};
exports.getServices = getServices;