"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensLayerSelectionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _layer = require("./layer");
var _job_from_lens = require("../../../../application/jobs/new_job/job_from_lens");
var _context = require("../../common/context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LensLayerSelectionFlyout = ({
  onClose,
  embeddable
}) => {
  var _getPanelTitle;
  const {
    services: {
      data,
      lens
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const [layerResults, setLayerResults] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const visExtractor = new _job_from_lens.VisualizationExtractor();
    visExtractor.getResultLayersFromEmbeddable(embeddable, lens).then(setLayerResults).catch(error => {
      // eslint-disable-next-line no-console
      console.error('Layers could not be extracted from embeddable', error);
      onClose();
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data, lens, embeddable]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.title",
    defaultMessage: "Create anomaly detection job"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.secondTitle",
    defaultMessage: "Select a compatible layer from the visualization {title} to create an anomaly detection job.",
    values: {
      title: (_getPanelTitle = (0, _presentationPublishing.getPanelTitle)(embeddable)) !== null && _getPanelTitle !== void 0 ? _getPanelTitle : ''
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, layerResults.map((layer, i) => /*#__PURE__*/_react.default.createElement(_layer.Layer, {
    layer: layer,
    layerIndex: i,
    key: layer.id,
    embeddable: embeddable
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.closeButton",
    defaultMessage: "Close"
  }))))));
};
exports.LensLayerSelectionFlyout = LensLayerSelectionFlyout;