"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobsObservable = getJobsObservable;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _parse_interval = require("../../../common/util/parse_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getJobsObservable(jobIds$, anomalyDetectorService, setErrorHandler) {
  return jobIds$.pipe((0, _rxjs.distinctUntilChanged)(_lodash.isEqual), (0, _rxjs.switchMap)(jobsIds => {
    return anomalyDetectorService.getJobs$(jobsIds).pipe((0, _rxjs.catchError)(e => {
      var _e$body;
      // Catch error to prevent the observable from completing
      setErrorHandler((_e$body = e.body) !== null && _e$body !== void 0 ? _e$body : e);
      return _rxjs.EMPTY;
    }));
  }), (0, _rxjs.map)(jobs => {
    const explorerJobs = jobs.map(job => {
      var _job$model_plot_confi;
      const bucketSpan = (0, _parse_interval.parseInterval)(job.analysis_config.bucket_span);
      return {
        id: job.job_id,
        selected: true,
        bucketSpanSeconds: bucketSpan.asSeconds(),
        modelPlotEnabled: ((_job$model_plot_confi = job.model_plot_config) === null || _job$model_plot_confi === void 0 ? void 0 : _job$model_plot_confi.enabled) === true
      };
    });
    return explorerJobs;
  }));
}