"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveAnomalySwimlaneUserInput = resolveAnomalySwimlaneUserInput;
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _http_service = require("../../application/services/http_service");
var _jobs = require("../../application/services/ml_api_service/jobs");
var _anomaly_swimlane_initializer = require("./anomaly_swimlane_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveAnomalySwimlaneUserInput(coreStart, parentApi, focusedPanelId, input) {
  const {
    http,
    overlays,
    ...startServices
  } = coreStart;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise(async (resolve, reject) => {
    try {
      const adJobsApiService = (0, _jobs.jobsApiProvider)(new _http_service.HttpService(http));
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart
        }
      }, /*#__PURE__*/_react.default.createElement(_anomaly_swimlane_initializer.AnomalySwimlaneInitializer, {
        adJobsApiService: adJobsApiService,
        initialInput: input,
        onCreate: explicitInput => {
          resolve(explicitInput);
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        },
        onCancel: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      })), startServices), {
        type: 'push',
        ownFocus: true,
        size: 's',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      });
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}