"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySwimlaneInitializer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _kibana = require("../../application/contexts/kibana");
var _locator = require("../../../common/constants/locator");
var _job_utils = require("../../../common/util/job_utils");
var _job_selector = require("../../alerting/job_selector");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _anomaly_swimlane_embeddable = require("./anomaly_swimlane_embeddable");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySwimlaneInitializer = ({
  onCreate,
  onCancel,
  initialInput,
  adJobsApiService
}) => {
  var _initialInput$jobIds, _initialInput$title, _initialInput$swimlan;
  const isMounted = (0, _useMountedState.default)();
  const titleManuallyChanged = (0, _react.useRef)(!!(initialInput !== null && initialInput !== void 0 && initialInput.title));
  const [jobIds, setJobIds] = (0, _react.useState)((_initialInput$jobIds = initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds) !== null && _initialInput$jobIds !== void 0 ? _initialInput$jobIds : []);
  const [influencers, setInfluencers] = (0, _react.useState)([_explorer_constants.VIEW_BY_JOB_LABEL]);
  (0, _react.useEffect)(function updateInfluencers() {
    async function fetchInfluencers() {
      const jobs = await adJobsApiService.jobs(jobIds);
      if (isMounted()) {
        setInfluencers([...(0, _job_utils.extractInfluencers)(jobs), _explorer_constants.VIEW_BY_JOB_LABEL]);
      }
    }
    if (jobIds.length > 0) {
      fetchInfluencers();
    }
  }, [adJobsApiService, isMounted, jobIds]);
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialInput$title = initialInput === null || initialInput === void 0 ? void 0 : initialInput.title) !== null && _initialInput$title !== void 0 ? _initialInput$title : '');
  const [swimlaneType, setSwimlaneType] = (0, _react.useState)((_initialInput$swimlan = initialInput === null || initialInput === void 0 ? void 0 : initialInput.swimlaneType) !== null && _initialInput$swimlan !== void 0 ? _initialInput$swimlan : _explorer_constants.SWIMLANE_TYPE.OVERALL);
  const [viewBySwimlaneFieldName, setViewBySwimlaneFieldName] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewBy);
  (0, _react.useEffect)(function updateDefaultTitle() {
    if (!titleManuallyChanged.current) {
      setPanelTitle((0, _anomaly_swimlane_embeddable.getDefaultSwimlanePanelTitle)(jobIds));
    }
  }, [initialInput === null || initialInput === void 0 ? void 0 : initialInput.title, jobIds]);
  const swimlaneTypeOptions = [{
    id: _explorer_constants.SWIMLANE_TYPE.OVERALL,
    label: _i18n.i18n.translate('xpack.ml.explorer.overallLabel', {
      defaultMessage: 'Overall'
    })
  }, {
    id: _explorer_constants.SWIMLANE_TYPE.VIEW_BY,
    label: _i18n.i18n.translate('xpack.ml.explorer.viewByLabel', {
      defaultMessage: 'View by'
    })
  }];
  const viewBySwimlaneOptions = ['', ...influencers].map(influencer => {
    return {
      value: influencer,
      text: influencer
    };
  });
  const isPanelTitleValid = panelTitle.length > 0;
  const jobIdsErrors = (0, _utils.getJobSelectionErrors)(jobIds);
  const isFormValid = isPanelTitleValid && !jobIdsErrors && (swimlaneType === _explorer_constants.SWIMLANE_TYPE.OVERALL || swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && !!viewBySwimlaneFieldName);
  const resultInput = {
    jobIds,
    panelTitle,
    swimlaneType,
    ...(viewBySwimlaneFieldName ? {
      viewBy: viewBySwimlaneFieldName
    } : {})
  };
  const newJobUrl = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.title",
    defaultMessage: "Anomaly swim lane configuration"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, {
    createJobUrl: newJobUrl,
    multiSelect: true,
    jobsAndGroupIds: jobIds,
    adJobsApiService: adJobsApiService,
    onChange: update => {
      var _update$jobIds, _update$groupIds;
      setJobIds([...((_update$jobIds = update === null || update === void 0 ? void 0 : update.jobIds) !== null && _update$jobIds !== void 0 ? _update$jobIds : []), ...((_update$groupIds = update === null || update === void 0 ? void 0 : update.groupIds) !== null && _update$groupIds !== void 0 ? _update$groupIds : [])]);
    },
    errors: jobIdsErrors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title"
    }),
    isInvalid: !isPanelTitleValid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => {
      titleManuallyChanged.current = true;
      setPanelTitle(e.target.value);
    },
    isInvalid: !isPanelTitleValid,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel",
      defaultMessage: "Swim lane type"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    id: "selectSwimlaneType",
    name: "selectSwimlaneType",
    color: "primary",
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.ml.swimlaneEmbeddable.setupModal.swimlaneTypeLabel', {
      defaultMessage: 'Swim lane type'
    }),
    options: swimlaneTypeOptions,
    idSelected: swimlaneType,
    onChange: id => setSwimlaneType(id)
  })), swimlaneType === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.viewByLabel",
      defaultMessage: "View by"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    id: "selectViewBy",
    name: "selectViewBy",
    options: viewBySwimlaneOptions,
    value: viewBySwimlaneFieldName,
    onChange: e => setViewBySwimlaneFieldName(e.target.value)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !isFormValid,
    onClick: onCreate.bind(null, resultInput),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.swimlaneEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm"
  }))))));
};
exports.AnomalySwimlaneInitializer = AnomalySwimlaneInitializer;