"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeAnomalyChartsControls = void 0;
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeAnomalyChartsControls = (rawState, titlesApi, parentApi) => {
  var _rawState$maxSeriesTo;
  const jobIds$ = new _rxjs.BehaviorSubject(rawState.jobIds);
  const maxSeriesToPlot$ = new _rxjs.BehaviorSubject((_rawState$maxSeriesTo = rawState.maxSeriesToPlot) !== null && _rawState$maxSeriesTo !== void 0 ? _rawState$maxSeriesTo : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const severityThreshold$ = new _rxjs.BehaviorSubject(rawState.severityThreshold);
  const selectedEntities$ = new _rxjs.BehaviorSubject(rawState.selectedEntities);
  const interval$ = new _rxjs.BehaviorSubject(undefined);
  const dataLoading$ = new _rxjs.BehaviorSubject(true);
  const blockingError$ = new _rxjs.BehaviorSubject(undefined);
  const updateUserInput = update => {
    jobIds$.next(update.jobIds);
    maxSeriesToPlot$.next(update.maxSeriesToPlot);
    if (titlesApi) {
      titlesApi.setPanelTitle(update.title);
    }
  };
  const updateSeverityThreshold = v => severityThreshold$.next(v);
  const updateSelectedEntities = v => selectedEntities$.next(v);
  const setInterval = v => interval$.next(v);
  const serializeAnomalyChartsState = () => {
    return {
      jobIds: jobIds$.value,
      maxSeriesToPlot: maxSeriesToPlot$.value,
      severityThreshold: severityThreshold$.value,
      selectedEntities: selectedEntities$.value
    };
  };
  const anomalyChartsComparators = {
    jobIds: [jobIds$, arg => jobIds$.next(arg), _fastDeepEqual.default],
    maxSeriesToPlot: [maxSeriesToPlot$, arg => maxSeriesToPlot$.next(arg)],
    severityThreshold: [severityThreshold$, arg => severityThreshold$.next(arg)],
    selectedEntities: [selectedEntities$, arg => selectedEntities$.next(arg), _fastDeepEqual.default]
  };
  const onRenderComplete = () => dataLoading$.next(false);
  const onLoading = v => dataLoading$.next(v);
  const onError = error => blockingError$.next(error);
  return {
    anomalyChartsControlsApi: {
      jobIds$,
      maxSeriesToPlot$,
      severityThreshold$,
      selectedEntities$,
      updateUserInput,
      updateSeverityThreshold,
      updateSelectedEntities
    },
    dataLoadingApi: {
      dataLoading: dataLoading$,
      setInterval,
      onRenderComplete,
      onLoading,
      onError
    },
    serializeAnomalyChartsState,
    anomalyChartsComparators,
    onAnomalyChartsDestroy: () => {
      jobIds$.complete();
      maxSeriesToPlot$.complete();
      severityThreshold$.complete();
      selectedEntities$.complete();
    }
  };
};
exports.initializeAnomalyChartsControls = initializeAnomalyChartsControls;