"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalyChartsServiceDependencies = void 0;
var _http_service = require("../../application/services/http_service");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAnomalyChartsServiceDependencies = async (coreStartServices, pluginsStartServices) => {
  const [{
    AnomalyDetectorService
  }, {
    fieldFormatServiceFactory
  }, {
    indexServiceFactory
  }, {
    mlApiServicesProvider
  }, {
    mlResultsServiceProvider
  }] = await Promise.all([await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/field_format_service_factory'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/util/index_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/results_service')))]);
  const httpService = new _http_service.HttpService(coreStartServices.http);
  const anomalyDetectorService = new AnomalyDetectorService(httpService);
  const mlApiServices = mlApiServicesProvider(httpService);
  const mlResultsService = mlResultsServiceProvider(mlApiServices);
  const anomalyExplorerService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(pluginsStartServices.data.query.timefilter.timefilter, mlApiServices, mlResultsService);

  // Note on the following services:
  // - `mlIndexUtils` is just instantiated here to be passed on to `mlFieldFormatService`,
  //   but it's not being made available as part of global services. Since it's just
  //   some stateless utils `useMlIndexUtils()` should be used from within components.
  // - `mlFieldFormatService` is a stateful legacy service that relied on "dependency cache",
  //   so because of its own state it needs to be made available as a global service.
  //   In the long run we should again try to get rid of it here and make it available via
  //   its own context or possibly without having a singleton like state at all, since the
  //   way this manages its own state right now doesn't consider React component lifecycles.
  const mlIndexUtils = indexServiceFactory(pluginsStartServices.data.dataViews);
  const mlFieldFormatService = fieldFormatServiceFactory(mlApiServices, mlIndexUtils);
  const anomalyChartsEmbeddableServices = [coreStartServices, pluginsStartServices, {
    anomalyDetectorService,
    anomalyExplorerService,
    mlFieldFormatService,
    mlResultsService
  }];
  return anomalyChartsEmbeddableServices;
};
exports.getAnomalyChartsServiceDependencies = getAnomalyChartsServiceDependencies;