"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _common = require("@kbn/data-plugin/common");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _explorer_anomalies_container = require("../../application/explorer/explorer_charts/explorer_anomalies_container");
var _locator = require("../../../common/constants/locator");
var _select_severity = require("../../application/components/controls/select_severity/select_severity");
var _triggers = require("../../ui_actions/triggers");
var _use_anomaly_charts_data = require("./use_anomaly_charts_data");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESIZE_THROTTLE_TIME_MS = 500;
const AnomalyChartsContainer = ({
  id,
  timeRange$,
  severityThreshold,
  services,
  onRenderComplete,
  onError,
  onLoading,
  api
}) => {
  const [chartWidth, setChartWidth] = (0, _react.useState)(0);
  const [severity, setSeverity] = (0, _react.useState)((0, _select_severity.optionValueToThreshold)(severityThreshold !== undefined ? severityThreshold : _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING));
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)();
  const [{
    uiSettings
  }, {
    data: dataServices,
    share,
    uiActions,
    charts: chartsService
  }] = services;
  const {
    timefilter
  } = dataServices.query.timefilter;
  const timeRange = (0, _useObservable.default)(timeRange$);
  const mlLocator = (0, _react.useMemo)(() => share.url.locators.get(_locator.ML_APP_LOCATOR), [share]);
  const timeBuckets = (0, _react.useMemo)(() => {
    return new _mlTimeBuckets.TimeBuckets({
      'histogram:maxBars': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      'histogram:barTarget': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (api !== null && api !== void 0 && api.updateSeverityThreshold) {
      api.updateSeverityThreshold(severity.val);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [severity.val, api === null || api === void 0 ? void 0 : api.updateSeverityThreshold]);
  (0, _react.useEffect)(() => {
    if (api !== null && api !== void 0 && api.updateSelectedEntities) {
      api.updateSelectedEntities(selectedEntities);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedEntities, api === null || api === void 0 ? void 0 : api.updateSelectedEntities]);
  const renderCallbacks = (0, _react.useMemo)(() => {
    return {
      onRenderComplete,
      onError,
      onLoading
    };
  }, [onRenderComplete, onError, onLoading]);
  const {
    chartsData,
    isLoading: isExplorerLoading,
    error
  } = (0, _use_anomaly_charts_data.useAnomalyChartsData)(api, services, chartWidth, severity.val, renderCallbacks);

  // Holds the container height for previously fetched data
  const containerHeightRef = (0, _react.useRef)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    // Keep previous container height so it doesn't change the page layout
    if (!isExplorerLoading) {
      containerHeightRef.current = e.height;
    }
    if (Math.abs(chartWidth - e.width) > 20) {
      setChartWidth(e.width);
    }
  }, RESIZE_THROTTLE_TIME_MS), [!isExplorerLoading, chartWidth]);
  const containerHeight = (0, _react.useMemo)(() => {
    // Persists container height during loading to prevent page from jumping
    return isExplorerLoading ? containerHeightRef.current : undefined;
  }, [isExplorerLoading]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyChartsEmbeddable.errorMessage",
        defaultMessage: "Unable to load the data for the anomaly charts"
      }),
      color: "danger",
      iconType: "warning",
      style: {
        width: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement("p", null, error.message));
  }
  const addEntityFieldFilter = (fieldName, fieldValue, operation) => {
    const entity = {
      fieldName,
      fieldValue,
      operation
    };
    const uniqueSelectedEntities = [entity];
    setSelectedEntities(uniqueSelectedEntities);
    uiActions.getTrigger(_triggers.EXPLORER_ENTITY_FIELD_SELECTION_TRIGGER).exec({
      embeddable: api,
      data: uniqueSelectedEntities
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlAnomalyExplorerEmbeddableWrapper-${id}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px',
      height: containerHeight
    },
    "data-test-subj": `mlExplorerEmbeddable_${id}`,
    ref: resizeRef
  }, isExplorerLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: 'center',
    style: {
      position: 'absolute',
      top: '50%',
      left: '50%',
      transform: 'translate(-50%,-50%)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl",
    mono: true,
    "data-test-subj": "mlAnomalyExplorerEmbeddableLoadingIndicator"
  })), chartsData !== undefined && isExplorerLoading === false ? /*#__PURE__*/_react.default.createElement(_explorer_anomalies_container.ExplorerAnomaliesContainer, {
    id: id,
    showCharts: true,
    chartsData: chartsData,
    severity: severity,
    setSeverity: setSeverity,
    mlLocator: mlLocator,
    timeBuckets: timeBuckets,
    timefilter: timefilter,
    onSelectEntity: addEntityFieldFilter,
    showSelectedInterval: false,
    chartsService: chartsService,
    timeRange: timeRange
  }) : null));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = AnomalyChartsContainer;
module.exports = exports.default;