"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearCache = clearCache;
exports.getApplication = getApplication;
exports.getDocLinks = getDocLinks;
exports.getFieldFormats = getFieldFormats;
exports.getHttp = getHttp;
exports.getI18n = getI18n;
exports.getRecentlyAccessed = getRecentlyAccessed;
exports.getTimefilter = getTimefilter;
exports.getToastNotifications = getToastNotifications;
exports.getUiSettings = getUiSettings;
exports.setDependencyCache = setDependencyCache;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cache = {
  timefilter: null,
  config: null,
  docLinks: null,
  toastNotifications: null,
  recentlyAccessed: null,
  fieldFormats: null,
  application: null,
  http: null,
  i18n: null,
  maps: null
};
function setDependencyCache(deps) {
  cache.timefilter = deps.timefilter || null;
  cache.config = deps.config || null;
  cache.docLinks = deps.docLinks || null;
  cache.toastNotifications = deps.toastNotifications || null;
  cache.recentlyAccessed = deps.recentlyAccessed || null;
  cache.fieldFormats = deps.fieldFormats || null;
  cache.application = deps.application || null;
  cache.http = deps.http || null;
  cache.i18n = deps.i18n || null;
}
function getTimefilter() {
  if (cache.timefilter === null) {
    throw new Error("timefilter hasn't been initialized");
  }
  return cache.timefilter.timefilter;
}
function getDocLinks() {
  if (cache.docLinks === null) {
    throw new Error("docLinks hasn't been initialized");
  }
  return cache.docLinks;
}
function getToastNotifications() {
  if (cache.toastNotifications === null) {
    throw new Error("toast notifications haven't been initialized");
  }
  return cache.toastNotifications;
}
function getUiSettings() {
  if (cache.config === null) {
    throw new Error("uiSettings hasn't been initialized");
  }
  return cache.config;
}
function getRecentlyAccessed() {
  if (cache.recentlyAccessed === null) {
    throw new Error("recentlyAccessed hasn't been initialized");
  }
  return cache.recentlyAccessed;
}
function getFieldFormats() {
  if (cache.fieldFormats === null) {
    throw new Error("fieldFormats hasn't been initialized");
  }
  return cache.fieldFormats;
}
function getApplication() {
  if (cache.application === null) {
    throw new Error("application hasn't been initialized");
  }
  return cache.application;
}
function getHttp() {
  if (cache.http === null) {
    throw new Error("http hasn't been initialized");
  }
  return cache.http;
}
function getI18n() {
  if (cache.i18n === null) {
    throw new Error("i18n hasn't been initialized");
  }
  return cache.i18n;
}
function clearCache() {
  Object.keys(cache).forEach(k => {
    cache[k] = null;
  });
}