"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _entity_control = require("../entity_control");
var _job_service = require("../../../services/job_service");
var _kibana = require("../../../contexts/kibana");
var _timeseriesexplorer_constants = require("../../timeseriesexplorer_constants");
var _entity_control2 = require("../entity_control/entity_control");
var _get_controls_for_detector = require("../../get_controls_for_detector");
var _storage = require("../../../../../common/types/storage");
var _get_viewable_detectors = require("../../timeseriesexplorer_utils/get_viewable_detectors");
var _plot_function_controls = require("../plot_function_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEntityControlOptions(fieldValues) {
  if (!Array.isArray(fieldValues)) {
    return [];
  }
  return fieldValues.map(value => {
    return {
      label: value.value === '' ? _entity_control2.EMPTY_FIELD_VALUE_LABEL : value.value,
      value
    };
  });
}
/**
 * Provides default fields configuration.
 */
const getDefaultFieldConfig = (fieldTypes, isAnomalousOnly, applyTimeRange) => {
  return fieldTypes.reduce((acc, f) => {
    acc[f] = {
      applyTimeRange,
      anomalousOnly: isAnomalousOnly,
      sort: {
        by: 'anomaly_score',
        order: 'desc'
      }
    };
    return acc;
  }, {});
};
/**
 * Component for handling the detector and entities controls.
 */
const SeriesControls = ({
  appStateHandler,
  bounds,
  children,
  direction = 'row',
  functionDescription,
  job,
  selectedDetectorIndex,
  selectedEntities,
  selectedJobId,
  setFunctionDescription
}) => {
  var _selectedJob$model_pl;
  const {
    services: {
      mlServices: {
        mlApiServices: {
          results: mlResultsService
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const selectedJob = (0, _react.useMemo)(() => job !== null && job !== void 0 ? job : _job_service.mlJobService.getJob(selectedJobId),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedJobId]);
  const isModelPlotEnabled = !!((_selectedJob$model_pl = selectedJob.model_plot_config) !== null && _selectedJob$model_pl !== void 0 && _selectedJob$model_pl.enabled);
  const [entitiesLoading, setEntitiesLoading] = (0, _react.useState)(false);
  const [entityValues, setEntityValues] = (0, _react.useState)({});
  const detectors = (0, _react.useMemo)(() => {
    return (0, _get_viewable_detectors.getViewableDetectors)(selectedJob);
  }, [selectedJob]);
  const entityControls = (0, _react.useMemo)(() => {
    return (0, _get_controls_for_detector.getControlsForDetector)(selectedDetectorIndex, selectedEntities, selectedJobId, selectedJob);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedDetectorIndex, selectedEntities, selectedJobId]);
  const [storageFieldsConfig, setStorageFieldsConfig] = (0, _mlLocalStorage.useStorage)(_storage.ML_ENTITY_FIELDS_CONFIG);

  // Merge the default config with the one from the local storage
  const resultFieldsConfig = (0, _react.useMemo)(() => {
    return {
      ...getDefaultFieldConfig(entityControls.map(v => v.fieldType), !storageFieldsConfig ? true : Object.values(storageFieldsConfig).some(v => !!(v !== null && v !== void 0 && v.anomalousOnly)), !storageFieldsConfig ? true : Object.values(storageFieldsConfig).some(v => !!(v !== null && v !== void 0 && v.applyTimeRange))),
      ...(!storageFieldsConfig ? {} : storageFieldsConfig)
    };
  }, [entityControls, storageFieldsConfig]);

  /**
   * Loads available entity values.
   * @param {Object} searchTerm - Search term for partition, e.g. { partition_field: 'partition' }
   */
  const loadEntityValues = async (searchTerm = {}) => {
    setEntitiesLoading(true);

    // Populate the entity input data lists with the values from the top records by score
    // for the selected detector across the full time range. No need to pass through finish().
    const detectorIndex = selectedDetectorIndex;
    const fieldsConfig = resultFieldsConfig ? Object.fromEntries(Object.entries(resultFieldsConfig).filter(([k]) => entityControls.some(v => v.fieldType === k))) : undefined;
    const {
      partition_field: partitionField,
      over_field: overField,
      by_field: byField
    } = await (0, _rxjs.lastValueFrom)(mlResultsService.fetchPartitionFieldsValues(selectedJob.job_id, searchTerm, [{
      fieldName: 'detector_index',
      fieldValue: detectorIndex
    }], bounds.min.valueOf(), bounds.max.valueOf(), fieldsConfig));
    const entityValuesUpdate = {};
    entityControls.forEach(entity => {
      let fieldValues;
      if ((partitionField === null || partitionField === void 0 ? void 0 : partitionField.name) === entity.fieldName) {
        fieldValues = partitionField.values;
      }
      if ((overField === null || overField === void 0 ? void 0 : overField.name) === entity.fieldName) {
        fieldValues = overField.values;
      }
      if ((byField === null || byField === void 0 ? void 0 : byField.name) === entity.fieldName) {
        fieldValues = byField.values;
      }
      entityValuesUpdate[entity.fieldName] = fieldValues;
    });
    setEntitiesLoading(false);
    setEntityValues(entityValuesUpdate);
  };
  (0, _react.useEffect)(() => {
    loadEntityValues();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedJobId, selectedDetectorIndex, JSON.stringify(selectedEntities), resultFieldsConfig]);
  const entityFieldSearchChanged = (0, _lodash.debounce)(async (entity, queryTerm) => {
    await loadEntityValues({
      [entity.fieldType]: queryTerm
    });
  }, 500);
  const entityFieldValueChanged = (entity, fieldValue) => {
    const resultEntities = {
      ...entityControls.reduce((appStateEntities, appStateEntity) => {
        appStateEntities[appStateEntity.fieldName] = appStateEntity.fieldValue;
        return appStateEntities;
      }, {}),
      [entity.fieldName]: fieldValue
    };
    appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_ENTITIES, resultEntities);
  };
  const detectorIndexChangeHandler = (0, _react.useCallback)(e => {
    const id = e.target.value;
    if (id !== undefined) {
      appStateHandler(_timeseriesexplorer_constants.APP_STATE_ACTION.SET_DETECTOR_INDEX, +id);
    }
  }, [appStateHandler]);
  const detectorSelectOptions = detectors.map(d => ({
    value: d.index,
    text: d.detector_description
  }));
  const onFieldConfigChange = (0, _react.useCallback)((fieldType, config) => {
    var _resultFieldsConfig$f, _resultFieldsConfig$f2;
    const updatedFieldConfig = {
      ...(resultFieldsConfig[fieldType] ? resultFieldsConfig[fieldType] : {}),
      ...config
    };
    const updatedResultConfig = {
      ...resultFieldsConfig
    };
    if (((_resultFieldsConfig$f = resultFieldsConfig[fieldType]) === null || _resultFieldsConfig$f === void 0 ? void 0 : _resultFieldsConfig$f.anomalousOnly) !== updatedFieldConfig.anomalousOnly) {
      // In case anomalous selector has been changed
      // we need to change it for all the other fields
      for (const c in updatedResultConfig) {
        if (updatedResultConfig.hasOwnProperty(c)) {
          updatedResultConfig[c].anomalousOnly = updatedFieldConfig.anomalousOnly;
        }
      }
    }
    if (((_resultFieldsConfig$f2 = resultFieldsConfig[fieldType]) === null || _resultFieldsConfig$f2 === void 0 ? void 0 : _resultFieldsConfig$f2.applyTimeRange) !== updatedFieldConfig.applyTimeRange) {
      // In case time range selector has been changed
      // we need to change it for all the other fields
      for (const c in updatedResultConfig) {
        if (updatedResultConfig.hasOwnProperty(c)) {
          updatedResultConfig[c].applyTimeRange = updatedFieldConfig.applyTimeRange;
        }
      }
    }
    setStorageFieldsConfig({
      ...updatedResultConfig,
      [fieldType]: updatedFieldConfig
    });
  }, [resultFieldsConfig, setStorageFieldsConfig]);

  /** Indicates if any of the previous controls is empty */
  let hasEmptyFieldValues = false;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlSingleMetricViewerSeriesControls"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: direction
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.detectorLabel",
      defaultMessage: "Detector"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    onChange: detectorIndexChangeHandler,
    value: selectedDetectorIndex,
    options: detectorSelectOptions,
    "data-test-subj": "mlSingleMetricViewerDetectorSelect"
  }))), entityControls.map(entity => {
    const entityKey = `${entity.fieldName}`;
    const forceSelection = !hasEmptyFieldValues && entity.fieldValue === null;
    hasEmptyFieldValues = !hasEmptyFieldValues && forceSelection;
    return /*#__PURE__*/_react.default.createElement(_entity_control.EntityControl, {
      entity: entity,
      entityFieldValueChanged: entityFieldValueChanged,
      isLoading: entitiesLoading,
      onSearchChange: entityFieldSearchChanged,
      config: resultFieldsConfig[entity.fieldType],
      onConfigChange: onFieldConfigChange,
      forceSelection: forceSelection,
      key: entityKey,
      options: getEntityControlOptions(entityValues[entity.fieldName]),
      isModelPlotEnabled: isModelPlotEnabled
    });
  }), /*#__PURE__*/_react.default.createElement(_plot_function_controls.PlotByFunctionControls, {
    job: job,
    selectedJobId: selectedJobId,
    selectedDetectorIndex: selectedDetectorIndex,
    selectedEntities: selectedEntities,
    functionDescription: functionDescription,
    setFunctionDescription: setFunctionDescription,
    entityControlsCount: entityControls.length
  }), children));
};
exports.SeriesControls = SeriesControls;