"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteFilterListModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _delete_filter_lists = require("./delete_filter_lists");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React modal for confirming deletion of filter lists.
 */
class DeleteFilterListModal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "closeModal", () => {
      this.setState({
        isModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "showModal", () => {
      this.setState({
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.doDelete();
    });
    this.state = {
      isModalVisible: false
    };
  }
  async doDelete() {
    const {
      selectedFilterLists,
      refreshFilterLists
    } = this.props;
    await (0, _delete_filter_lists.deleteFilterLists)(selectedFilterLists);
    refreshFilterLists();
    this.closeModal();
  }
  render() {
    const {
      selectedFilterLists,
      canDeleteFilter
    } = this.props;
    let modal;
    if (this.state.isModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        title: _i18n.i18n.translate('xpack.ml.settings.filterLists.deleteFilterListModal.modalTitle', {
          defaultMessage: 'Delete {selectedFilterListsLength, plural, one {{selectedFilterId}} other {# filter lists}}?',
          values: {
            selectedFilterListsLength: selectedFilterLists.length,
            selectedFilterId: !!selectedFilterLists.length && selectedFilterLists[0].filter_id
          }
        }),
        className: "eui-textBreakWord",
        onCancel: this.closeModal,
        onConfirm: this.onConfirmDelete,
        cancelButtonText: _i18n.i18n.translate('xpack.ml.settings.filterLists.deleteFilterListModal.cancelButtonLabel', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.settings.filterLists.deleteFilterListModal.confirmButtonLabel', {
          defaultMessage: 'Delete'
        }),
        buttonColor: "danger",
        defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
        "data-test-subj": 'mlFilterListDeleteConfirmation'
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "delete_filter_list",
      iconType: "trash",
      color: "danger",
      onClick: this.showModal,
      isDisabled: selectedFilterLists === undefined || selectedFilterLists.length === 0 || canDeleteFilter === false,
      "data-test-subj": "mlFilterListsDeleteButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.settings.filterLists.deleteFilterListModal.deleteButtonLabel",
      defaultMessage: "Delete"
    })), modal);
  }
}
exports.DeleteFilterListModal = DeleteFilterListModal;
(0, _defineProperty2.default)(DeleteFilterListModal, "displayName", 'DeleteFilterListModal');
(0, _defineProperty2.default)(DeleteFilterListModal, "propTypes", {
  selectedFilterLists: _propTypes.default.array,
  canDeleteFilter: _propTypes.default.bool.isRequired
});