"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToastNotificationService = getToastNotificationService;
exports.toastNotificationServiceProvider = toastNotificationServiceProvider;
exports.useToastNotificationService = useToastNotificationService;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _dependency_cache = require("../../util/dependency_cache");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toastNotificationServiceProvider(toastNotifications) {
  function displayDangerToast(toastOrTitle, options) {
    toastNotifications.addDanger(toastOrTitle, options);
  }
  function displayWarningToast(toastOrTitle, options) {
    toastNotifications.addWarning(toastOrTitle, options);
  }
  function displaySuccessToast(toastOrTitle, options) {
    toastNotifications.addSuccess(toastOrTitle, options);
  }
  function displayErrorToast(error, title, toastLifeTimeMs) {
    const errorObj = (0, _mlErrorUtils.extractErrorProperties)(error);
    toastNotifications.addError(new _mlErrorUtils.MLRequestFailure(errorObj, error), {
      title: title !== null && title !== void 0 ? title : _i18n.i18n.translate('xpack.ml.toastNotificationService.errorTitle', {
        defaultMessage: 'An error has occurred'
      }),
      ...(toastLifeTimeMs ? {
        toastLifeTimeMs
      } : {})
    });
  }
  return {
    displayDangerToast,
    displayWarningToast,
    displaySuccessToast,
    displayErrorToast
  };
}
function getToastNotificationService() {
  const toastNotifications = (0, _dependency_cache.getToastNotifications)();
  return toastNotificationServiceProvider(toastNotifications);
}

/**
 * Hook to use {@link ToastNotificationService} in React components.
 */
function useToastNotificationService() {
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  // eslint-disable-next-line react-hooks/exhaustive-deps
  return (0, _react.useMemo)(() => toastNotificationServiceProvider(toasts), []);
}