"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDfaTrainedModel = isDfaTrainedModel;
exports.isTestable = isTestable;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PYTORCH_TYPES = Object.values(_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS);
function isDfaTrainedModel(modelItem) {
  var _modelItem$metadata, _modelItem$inference_, _modelItem$inference_2;
  return ((_modelItem$metadata = modelItem.metadata) === null || _modelItem$metadata === void 0 ? void 0 : _modelItem$metadata.analytics_config) !== undefined || ((_modelItem$inference_ = modelItem.inference_config) === null || _modelItem$inference_ === void 0 ? void 0 : _modelItem$inference_.regression) !== undefined || ((_modelItem$inference_2 = modelItem.inference_config) === null || _modelItem$inference_2 === void 0 ? void 0 : _modelItem$inference_2.classification) !== undefined;
}
function isTestable(modelItem, checkForState = false) {
  var _modelItem$inference_3, _modelItem$stats, _modelItem$stats$depl;
  if (modelItem.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH && PYTORCH_TYPES.includes(Object.keys((_modelItem$inference_3 = modelItem.inference_config) !== null && _modelItem$inference_3 !== void 0 ? _modelItem$inference_3 : {})[0]) && (checkForState === false || (_modelItem$stats = modelItem.stats) !== null && _modelItem$stats !== void 0 && (_modelItem$stats$depl = _modelItem$stats.deployment_stats) !== null && _modelItem$stats$depl !== void 0 && _modelItem$stats$depl.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED))) {
    return true;
  }
  if (modelItem.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.LANG_IDENT) {
    return true;
  }
  return isDfaTrainedModel(modelItem);
}