"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestTrainedModelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _selected_model = require("./selected_model");
var _inference_base = require("./models/inference_base");
var _test_trained_models_context = require("./test_trained_models_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestTrainedModelContent = ({
  model,
  handlePipelineConfigUpdate,
  externalPipelineConfig
}) => {
  const [deploymentId, setDeploymentId] = (0, _react.useState)(model.deployment_ids[0]);
  const mediumPadding = (0, _eui.useEuiPaddingSize)('m');
  const [inputType, setInputType] = (0, _react.useState)(_inference_base.INPUT_TYPE.TEXT);
  const {
    currentContext: {
      createPipelineFlyoutOpen
    },
    setCurrentContext
  } = (0, _test_trained_models_context.useTestTrainedModelsContext)();
  const onlyShowTab = (0, _react.useMemo)(() => {
    var _model$type;
    return ((_model$type = model.type) !== null && _model$type !== void 0 ? _model$type : []).includes(_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION) || createPipelineFlyoutOpen ? _inference_base.INPUT_TYPE.INDEX : undefined;
  }, [model, createPipelineFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', model.deployment_ids.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.testModelsFlyout.deploymentIdLabel",
      defaultMessage: "Deployment ID"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: model.deployment_ids.map(v => {
      return {
        text: v,
        value: v
      };
    }),
    value: deploymentId,
    onChange: e => {
      setDeploymentId(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, onlyShowTab === undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: {
      marginTop: `-${mediumPadding}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: inputType === _inference_base.INPUT_TYPE.TEXT,
    onClick: () => setInputType(_inference_base.INPUT_TYPE.TEXT)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.textTab",
    defaultMessage: "Test using text"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: inputType === _inference_base.INPUT_TYPE.INDEX,
    onClick: () => setInputType(_inference_base.INPUT_TYPE.INDEX)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.indexTab",
    defaultMessage: "Test using existing index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_selected_model.SelectedModel, {
    model: model,
    inputType: onlyShowTab !== null && onlyShowTab !== void 0 ? onlyShowTab : inputType,
    deploymentId: deploymentId !== null && deploymentId !== void 0 ? deploymentId : model.model_id,
    handlePipelineConfigUpdate: handlePipelineConfigUpdate,
    externalPipelineConfig: externalPipelineConfig,
    setCurrentContext: setCurrentContext
  }));
};
exports.TestTrainedModelContent = TestTrainedModelContent;