"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuestionAnsweringInference = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _inference_base = require("../inference_base");
var _question_answering_input = require("./question_answering_input");
var _question_answering_output = require("./question_answering_output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class QuestionAnsweringInference extends _inference_base.InferenceBase {
  constructor(trainedModelsApi, model, inputType, deploymentId) {
    super(trainedModelsApi, model, inputType, deploymentId);
    (0, _defineProperty2.default)(this, "inferenceType", _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING);
    (0, _defineProperty2.default)(this, "inferenceTypeLabel", _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.questionAnswer.label', {
      defaultMessage: 'Question answering'
    }));
    (0, _defineProperty2.default)(this, "info", [_i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.questionAnswer.info1', {
      defaultMessage: 'Provide a question and test how well the model extracts an answer from your input text.'
    })]);
    (0, _defineProperty2.default)(this, "questionText$", new _rxjs.BehaviorSubject(''));
    this.initialize([this.questionText$.pipe((0, _rxjs.map)(questionText => questionText !== ''))], [this.questionText$]);
  }
  async inferText() {
    return this.runInfer(() => {
      const question = this.questionText$.value;
      return this.getInferenceConfig({
        ...this.getNumTopClassesConfig(),
        question
      });
    }, (resp, inputText) => {
      return processResponse(resp, inputText);
    });
  }
  async inferIndex() {
    return this.runPipelineSimulate(doc => {
      const pretendRawRequest = {
        inference_results: [doc._source[this.inferenceType]]
      };
      const inputText = doc._source[this.getInputField()];
      return processResponse(pretendRawRequest, inputText);
    });
  }
  getProcessors() {
    const question = this.questionText$.value;
    return this.getBasicProcessors({
      ...this.getNumTopClassesConfig(),
      question
    });
  }
  setQuestionText(text) {
    this.questionText$.next(text);
  }
  getQuestionText$() {
    return this.questionText$.asObservable();
  }
  getQuestionText() {
    return this.questionText$.getValue();
  }
  getInputComponent() {
    const placeholder = _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.questionAnswer.inputText', {
      defaultMessage: "Enter unstructured text phrases related to the answers you're seeking"
    });
    return (0, _question_answering_input.getQuestionAnsweringInput)(this, placeholder);
  }
  getOutputComponent() {
    return (0, _question_answering_output.getQuestionAnsweringOutputComponent)(this);
  }
}
exports.QuestionAnsweringInference = QuestionAnsweringInference;
function processResponse(resp, inputText) {
  const {
    inference_results: [inferenceResults]
  } = resp;
  let formattedResponse = [{
    value: inferenceResults.predicted_value,
    predictionProbability: inferenceResults.prediction_probability,
    startOffset: inferenceResults.start_offset,
    endOffset: inferenceResults.end_offset
  }];
  if (inferenceResults.top_classes !== undefined) {
    formattedResponse = inferenceResults.top_classes.map(topClass => {
      return {
        value: topClass.answer,
        predictionProbability: topClass.score,
        startOffset: topClass.start_offset,
        endOffset: topClass.end_offset
      };
    });
  }
  return {
    response: formattedResponse,
    rawResponse: resp,
    inputText
  };
}