"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultModelsListState = exports.ModelsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _get_model_state = require("./get_model_state");
var _storage = require("../../../common/types/storage");
var _technical_preview_badge = require("../components/technical_preview_badge");
var _model_actions = require("./model_actions");
var _config_mapping = require("./config_mapping");
var _stats_bar = require("../components/stats_bar");
var _kibana = require("../contexts/kibana");
var _trained_models = require("../services/ml_api_service/trained_models");
var _delete_models_modal = require("./delete_models_modal");
var _locator = require("../../../common/constants/locator");
var _use_table_settings = require("../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _toast_notification_service = require("../services/toast_notification_service");
var _use_field_formatter = require("../contexts/kibana/use_field_formatter");
var _use_refresh = require("../routing/use_refresh");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _test_models = require("./test_models");
var _test_dfa_models_flyout = require("./test_dfa_models_flyout");
var _ml_inference = require("../components/ml_inference");
var _ml = require("../contexts/ml");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExpandedRow = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./expanded_row')))).ExpandedRow
}));
const AddModelFlyout = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./add_model_flyout')))).AddModelFlyout
}));
const modelIdColumnName = _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelIdHeader', {
  defaultMessage: 'ID'
});
const getDefaultModelsListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: modelIdColumnName,
  sortDirection: 'asc'
});
exports.getDefaultModelsListState = getDefaultModelsListState;
const DOWNLOAD_POLL_INTERVAL = 3000;
const ModelsList = ({
  pageState: pageStateExternal,
  updatePageState: updatePageStateExternal
}) => {
  var _pageState$queryText;
  const isMounted = (0, _useMountedState.default)();
  const {
    services: {
      application: {
        capabilities
      },
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const nlpElserDocUrl = docLinks.links.ml.nlpElser;
  const {
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const [isElserCalloutDismissed, setIsElserCalloutDismissed] = (0, _mlLocalStorage.useStorage)(_storage.ML_ELSER_CALLOUT_DISMISSED, false);
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);

  // allow for an internally controlled page state which stores the state in the URL
  // or an external page state, which is passed in as a prop.
  // external page state is used on the management page.
  const [pageStateInternal, updatePageStateInternal] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE, getDefaultModelsListState());
  const [pageState, updatePageState] = pageStateExternal && updatePageStateExternal ? [pageStateExternal, updatePageStateExternal] : [pageStateInternal, updatePageStateInternal];
  const refresh = (0, _use_refresh.useRefresh)();
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const canDeleteTrainedModels = capabilities.ml.canDeleteTrainedModels;
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const [selectedModels, setSelectedModels] = (0, _react.useState)([]);
  const [modelsToDelete, setModelsToDelete] = (0, _react.useState)([]);
  const [modelToDeploy, setModelToDeploy] = (0, _react.useState)();
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const [modelToTest, setModelToTest] = (0, _react.useState)(null);
  const [dfaModelToTest, setDfaModelToTest] = (0, _react.useState)(null);
  const [isAddModelFlyoutVisible, setIsAddModelFlyoutVisible] = (0, _react.useState)(false);
  const isBuiltInModel = (0, _react.useCallback)(item => item.tags.includes(_mlTrainedModelsUtils.BUILT_IN_MODEL_TAG), []);
  const isElasticModel = (0, _react.useCallback)(item => item.tags.includes(_mlTrainedModelsUtils.ELASTIC_MODEL_TAG), []);

  // List of downloaded/existing models
  const existingModels = (0, _react.useMemo)(() => {
    return items.filter(i => !i.putModelConfig);
  }, [items]);

  /**
   * Checks if the model download complete.
   */
  const isDownloadComplete = (0, _react.useCallback)(async modelId => {
    try {
      var _response$;
      const response = await trainedModelsApiService.getTrainedModels(modelId, {
        include: 'definition_status'
      });
      // @ts-ignore
      return !!((_response$ = response[0]) !== null && _response$ !== void 0 && _response$.fully_defined);
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.downloadStatusCheckErrorMessage', {
        defaultMessage: 'Failed to check download status'
      }));
    }
    return false;
  }, [trainedModelsApiService, displayErrorToast]);

  /**
   * Fetches trained models.
   */
  const fetchModelsData = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const response = await trainedModelsApiService.getTrainedModels(undefined, {
        with_pipelines: true,
        with_indices: true
      });
      const newItems = [];
      const expandedItemsToRefresh = [];
      for (const model of response) {
        const tableItem = {
          ...model,
          // Extract model types
          ...(typeof model.inference_config === 'object' ? {
            type: [model.model_type, ...Object.keys(model.inference_config), ...(isBuiltInModel(model) ? [_mlTrainedModelsUtils.BUILT_IN_MODEL_TYPE] : []), ...(isElasticModel(model) ? [_mlTrainedModelsUtils.ELASTIC_MODEL_TYPE] : [])]
          } : {})
        };
        newItems.push(tableItem);
        if (itemIdToExpandedRowMap[model.model_id]) {
          expandedItemsToRefresh.push(tableItem);
        }
      }

      // Need to fetch stats for all models to enable/disable actions
      // TODO combine fetching models definitions and stats into a single function
      await fetchModelsStats(newItems);
      let resultItems = newItems;
      // don't add any of the built-in models (e.g. elser) if NLP is disabled
      if (isNLPEnabled) {
        const idMap = new Map(resultItems.map(model => [model.model_id, model]));
        const forDownload = await trainedModelsApiService.getTrainedModelDownloads();
        const notDownloaded = forDownload.filter(({
          model_id: modelId,
          hidden,
          recommended
        }) => {
          if (recommended && idMap.has(modelId)) {
            idMap.get(modelId).recommended = true;
          }
          return !idMap.has(modelId) && !hidden;
        }).map(modelDefinition => {
          var _modelDefinition$type;
          return {
            model_id: modelDefinition.model_id,
            type: modelDefinition.type,
            tags: (_modelDefinition$type = modelDefinition.type) !== null && _modelDefinition$type !== void 0 && _modelDefinition$type.includes(_mlTrainedModelsUtils.ELASTIC_MODEL_TAG) ? [_mlTrainedModelsUtils.ELASTIC_MODEL_TAG] : [],
            putModelConfig: modelDefinition.config,
            description: modelDefinition.description,
            state: _mlTrainedModelsUtils.MODEL_STATE.NOT_DOWNLOADED,
            recommended: !!modelDefinition.recommended,
            modelName: modelDefinition.modelName,
            os: modelDefinition.os,
            arch: modelDefinition.arch,
            softwareLicense: modelDefinition.license,
            licenseUrl: modelDefinition.licenseUrl
          };
        });
        resultItems = [...resultItems, ...notDownloaded];
      }
      setItems(resultItems);
      if (expandedItemsToRefresh.length > 0) {
        await fetchModelsStats(expandedItemsToRefresh);
        setItemIdToExpandedRowMap(expandedItemsToRefresh.reduce((acc, item) => {
          acc[item.model_id] = /*#__PURE__*/_react.default.createElement(ExpandedRow, {
            item: item
          });
          return acc;
        }, {}));
      }
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchFailedErrorMessage', {
        defaultMessage: 'Error loading trained models'
      }));
    }
    setIsInitialized(true);
    setIsLoading(false);
    await fetchDownloadStatus();

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [itemIdToExpandedRowMap, isNLPEnabled]);
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    if (!refresh) return;
    fetchModelsData();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refresh]);
  const modelsStats = (0, _react.useMemo)(() => {
    return {
      total: {
        show: true,
        value: existingModels.length,
        label: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.totalAmountLabel', {
          defaultMessage: 'Total trained models'
        })
      }
    };
  }, [existingModels]);

  /**
   * Fetches models stats and update the original object
   */
  const fetchModelsStats = (0, _react.useCallback)(async models => {
    try {
      if (models) {
        const {
          trained_model_stats: modelsStatsResponse
        } = await trainedModelsApiService.getTrainedModelStats();
        const groupByModelId = (0, _lodash.groupBy)(modelsStatsResponse, 'model_id');
        models.forEach(model => {
          var _model$stats;
          const modelStats = groupByModelId[model.model_id];
          model.stats = {
            ...((_model$stats = model.stats) !== null && _model$stats !== void 0 ? _model$stats : {}),
            ...modelStats[0],
            deployment_stats: modelStats.map(d => d.deployment_stats).filter(_mlIsDefined.isDefined)
          };

          // Extract deployment ids from deployment stats
          model.deployment_ids = modelStats.map(v => {
            var _v$deployment_stats;
            return (_v$deployment_stats = v.deployment_stats) === null || _v$deployment_stats === void 0 ? void 0 : _v$deployment_stats.deployment_id;
          }).filter(_mlIsDefined.isDefined);
          model.state = (0, _get_model_state.getModelDeploymentState)(model);
          model.stateDescription = model.stats.deployment_stats.reduce((acc, c) => {
            var _c$reason;
            if (acc) return acc;
            return (_c$reason = c.reason) !== null && _c$reason !== void 0 ? _c$reason : '';
          }, '');
        });
        const elasticModels = models.filter(model => _mlTrainedModelsUtils.ELASTIC_MODEL_DEFINITIONS.hasOwnProperty(model.model_id));
        if (elasticModels.length > 0) {
          for (const model of elasticModels) {
            if (Object.values(_mlTrainedModelsUtils.DEPLOYMENT_STATE).includes(model.state)) {
              // no need to check for the download status if the model has been deployed
              continue;
            }
            const isDownloaded = await isDownloadComplete(model.model_id);
            model.state = isDownloaded ? _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED : _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING;
          }
        }
      }
      return true;
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchModelStatsErrorMessage', {
        defaultMessage: 'Error loading trained models statistics'
      }));
      return false;
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const downLoadStatusFetchInProgress = (0, _react.useRef)(false);
  /**
   * Updates model list with download status
   */
  const fetchDownloadStatus = (0, _react.useCallback)(
  /**
   * @param downloadInProgress Set of model ids that reports download in progress
   */
  async (downloadInProgress = new Set()) => {
    // Allows only single fetch to be in progress
    if (downLoadStatusFetchInProgress.current && downloadInProgress.size === 0) return;
    try {
      downLoadStatusFetchInProgress.current = true;
      const downloadStatus = await trainedModelsApiService.getModelsDownloadStatus();
      if (isMounted()) {
        setItems(prevItems => {
          return prevItems.map(item => {
            const newItem = {
              ...item
            };
            if (downloadStatus[item.model_id]) {
              newItem.downloadState = downloadStatus[item.model_id];
            } else {
              if (downloadInProgress.has(item.model_id)) {
                // Change downloading state to downloaded
                delete newItem.downloadState;
                newItem.state = _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADED;
              }
            }
            return newItem;
          });
        });
      }
      const downloadedModelIds = Array.from(downloadInProgress).filter(v => !downloadStatus[v]);
      if (downloadedModelIds.length > 0) {
        // Show success toast
        displaySuccessToast(_i18n.i18n.translate('xpack.ml.trainedModels.modelsList.downloadCompleteSuccess', {
          defaultMessage: '"{modelIds}" {modelIdsLength, plural, one {has} other {have}} been downloaded successfully.',
          values: {
            modelIds: downloadedModelIds.join(', '),
            modelIdsLength: downloadedModelIds.length
          }
        }));
      }
      Object.keys(downloadStatus).forEach(modelId => {
        if (downloadStatus[modelId]) {
          downloadInProgress.add(modelId);
        }
      });
      downloadedModelIds.forEach(v => {
        downloadInProgress.delete(v);
      });
      if ((0, _lodash.isEmpty)(downloadStatus)) {
        downLoadStatusFetchInProgress.current = false;
        return;
      }
      await new Promise(resolve => setTimeout(resolve, DOWNLOAD_POLL_INTERVAL));
      await fetchDownloadStatus(downloadInProgress);
    } catch (e) {
      downLoadStatusFetchInProgress.current = false;
    }
  }, [trainedModelsApiService, displaySuccessToast, isMounted]);

  /**
   * Unique inference types from models
   */
  const inferenceTypesOptions = (0, _react.useMemo)(() => {
    const result = existingModels.reduce((acc, item) => {
      const type = item.inference_config && Object.keys(item.inference_config)[0];
      if (type) {
        acc.add(type);
      }
      acc.add(item.model_type);
      return acc;
    }, new Set());
    return [...result].sort((a, b) => a.localeCompare(b)).map(v => ({
      value: v,
      name: v
    }));
  }, [existingModels]);
  const modelAndDeploymentIds = (0, _react.useMemo)(() => [...new Set([...existingModels.flatMap(v => v.deployment_ids), ...existingModels.map(i => i.model_id)])], [existingModels]);
  const onModelDownloadRequest = (0, _react.useCallback)(async modelId => {
    try {
      setIsLoading(true);
      await trainedModelsApiService.installElasticTrainedModelConfig(modelId);
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.trainedModels.modelsList.downloadSuccess', {
        defaultMessage: '"{modelId}" model download has been started successfully.',
        values: {
          modelId
        }
      }));
      // Need to fetch model state updates
      await fetchModelsData();
    } catch (e) {
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.downloadFailed', {
        defaultMessage: 'Failed to download "{modelId}"',
        values: {
          modelId
        }
      }));
      setIsLoading(true);
    }
  }, [displayErrorToast, displaySuccessToast, fetchModelsData, trainedModelsApiService]);

  /**
   * Table actions
   */
  const actions = (0, _model_actions.useModelActions)({
    isLoading,
    fetchModels: fetchModelsData,
    onTestAction: setModelToTest,
    onDfaTestAction: setDfaModelToTest,
    onModelsDeleteRequest: setModelsToDelete,
    onModelDeployRequest: setModelToDeploy,
    onLoading: setIsLoading,
    modelAndDeploymentIds,
    onModelDownloadRequest
  });
  const toggleDetails = async item => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[item.model_id]) {
      delete itemIdToExpandedRowMapValues[item.model_id];
    } else {
      await fetchModelsStats([item]);
      itemIdToExpandedRowMapValues[item.model_id] = /*#__PURE__*/_react.default.createElement(ExpandedRow, {
        item: item
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    align: 'left',
    width: '32px',
    isExpander: true,
    render: item => {
      if (!item.stats) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: toggleDetails.bind(null, item),
        "aria-label": itemIdToExpandedRowMap[item.model_id] ? _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.collapseRow', {
          defaultMessage: 'Collapse'
        }) : _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.expandRow', {
          defaultMessage: 'Expand'
        }),
        iconType: itemIdToExpandedRowMap[item.model_id] ? 'arrowDown' : 'arrowRight'
      });
    },
    'data-test-subj': 'mlModelsTableRowDetailsToggle'
  }, {
    name: modelIdColumnName,
    width: '15%',
    sortable: ({
      model_id: modelId
    }) => modelId,
    truncateText: false,
    textOnly: false,
    'data-test-subj': 'mlModelsTableColumnId',
    render: ({
      description,
      model_id: modelId
    }) => {
      const isTechPreview = description === null || description === void 0 ? void 0 : description.includes('(Tech Preview)');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: 's',
        alignItems: 'center',
        wrap: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, modelId), isTechPreview ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
        compressed: true
      })) : null);
    }
  }, {
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.modelDescriptionHeader', {
      defaultMessage: 'Description'
    }),
    truncateText: false,
    'data-test-subj': 'mlModelsTableColumnDescription',
    render: ({
      description,
      recommended
    }) => {
      if (!description) return null;
      const descriptionText = description.replace('(Tech Preview)', '');
      return recommended ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.recommendedDownloadContent",
          defaultMessage: "Recommended model version for your cluster's hardware configuration"
        })
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, descriptionText, "\xA0", /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.recommendedDownloadLabel",
        defaultMessage: "(Recommended)"
      })))) : descriptionText;
    }
  }, {
    width: '15%',
    field: _config_mapping.ModelsTableToConfigMapping.type,
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.typeHeader', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    truncateText: true,
    align: 'left',
    render: types => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs',
      wrap: true
    }, types.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: type,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "data-test-subj": "mlModelType"
    }, type)))),
    'data-test-subj': 'mlModelsTableColumnType'
  }, {
    width: '10%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.stateHeader', {
      defaultMessage: 'State'
    }),
    align: 'left',
    truncateText: false,
    render: ({
      state,
      downloadState
    }) => {
      const config = (0, _get_model_state.getModelStateColor)(state);
      if (!config) return null;
      const isDownloadInProgress = state === _mlTrainedModelsUtils.MODEL_STATE.DOWNLOADING && downloadState;
      const label = /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        textSize: 'xs',
        color: config.color
      }, config.name);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: 'column',
        gutterSize: 'none'
      }, isDownloadInProgress ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        label: label,
        valueText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (downloadState.downloaded_parts / downloadState.total_parts * 100).toFixed(0) + '%'),
        value: downloadState === null || downloadState === void 0 ? void 0 : downloadState.downloaded_parts,
        max: downloadState === null || downloadState === void 0 ? void 0 : downloadState.total_parts,
        size: "xs",
        color: config.color
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, label));
    },
    'data-test-subj': 'mlModelsTableColumnDeploymentState'
  }, {
    width: '20%',
    field: _config_mapping.ModelsTableToConfigMapping.createdAt,
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.createdAtHeader', {
      defaultMessage: 'Created at'
    }),
    dataType: 'date',
    render: v => dateFormatter(v),
    sortable: true,
    'data-test-subj': 'mlModelsTableColumnCreatedAt'
  }, {
    width: '15%',
    name: _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.actionsHeader', {
      defaultMessage: 'Actions'
    }),
    actions,
    'data-test-subj': 'mlModelsTableColumnActions'
  }];
  const filters = inferenceTypesOptions && inferenceTypesOptions.length > 0 ? [{
    type: 'field_value_selection',
    field: 'type',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.typeFilter', {
      defaultMessage: 'Type'
    }),
    multiSelect: 'or',
    options: inferenceTypesOptions
  }] : [];
  const toolsLeft = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.selectedModelsMessage",
    defaultMessage: "{modelsCount, plural, one{# model} other {# models}} selected",
    values: {
      modelsCount: selectedModels.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: setModelsToDelete.bind(null, selectedModels),
    "data-test-subj": "mlTrainedModelsDeleteSelectedModelsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModelsButtonLabel",
    defaultMessage: "Delete"
  })))));
  const isSelectionAllowed = canDeleteTrainedModels;
  const selection = isSelectionAllowed ? {
    selectableMessage: (selectable, item) => {
      if (selectable) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.selectableMessage', {
          defaultMessage: 'Select a model'
        });
      }
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.disableSelectableMessage', {
          defaultMessage: 'Model has associated pipelines'
        });
      }
      if (isBuiltInModel(item)) {
        return _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.builtInModelMessage', {
          defaultMessage: 'Built-in model'
        });
      }
      return '';
    },
    selectable: item => !(0, _mlIsPopulatedObject.isPopulatedObject)(item.pipelines) && !isBuiltInModel(item) && !(isElasticModel(item) && !item.state),
    onSelectionChange: selectedItems => {
      setSelectedModels(selectedItems);
    }
  } : undefined;
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _use_table_settings.useTableSettings)(items.length, pageState, updatePageState);
  const search = {
    query: searchQueryText,
    onChange: searchChange => {
      if (searchChange.error !== null) {
        return false;
      }
      updatePageState({
        queryText: searchChange.queryText,
        pageIndex: 0
      });
      return true;
    },
    box: {
      incremental: true
    },
    ...(inferenceTypesOptions && inferenceTypesOptions.length > 0 ? {
      filters
    } : {}),
    ...(selectedModels.length > 0 ? {
      toolsLeft
    } : {})
  };
  const isElserCalloutVisible = !isElserCalloutDismissed && items.findIndex(i => i.model_id === _mlTrainedModelsUtils.ELSER_ID_V1) >= 0;
  if (!isInitialized) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: fetchModelsData,
    forceRefresh: isLoading
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, modelsStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: modelsStats,
    dataTestSub: 'mlInferenceModelsStatsBar'
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: 'plusInCircle',
    color: 'primary',
    onClick: setIsAddModelFlyoutVisible.bind(null, true),
    "data-test-subj": "mlModelsAddTrainedModelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.addModelButtonLabel",
    defaultMessage: "Add trained model"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlModelsTableContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    responsiveBreakpoint: 'xl',
    allowNeutralSort: false,
    columns: columns,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: items,
    itemId: _config_mapping.ModelsTableToConfigMapping.id,
    loading: isLoading,
    search: search,
    selection: selection,
    rowProps: item => ({
      'data-test-subj': `mlModelsTableRow row-${item.model_id}`
    }),
    pagination: pagination,
    onTableChange: onTableChange,
    sorting: sorting,
    "data-test-subj": isLoading ? 'mlModelsTable loading' : 'mlModelsTable loaded',
    childrenBetween: isElserCalloutVisible ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.newElserModelTitle",
        defaultMessage: "New ELSER model now available"
      }),
      onDismiss: setIsElserCalloutDismissed.bind(null, true)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.newElserModelDescription",
      defaultMessage: "A new version of ELSER that shows faster performance and improved relevance is now available. {docLink} for information on how to start using it.",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: nlpElserDocUrl,
          external: true,
          target: '_blank'
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.trainedModels.modelsList.startDeployment.viewElserDocLink",
          defaultMessage: "View documentation"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })) : null
  })), modelsToDelete.length > 0 && /*#__PURE__*/_react.default.createElement(_delete_models_modal.DeleteModelsModal, {
    onClose: refreshList => {
      setModelsToDelete([]);
      if (refreshList) {
        fetchModelsData();
      }
    },
    models: modelsToDelete
  }), modelToTest === null ? null : /*#__PURE__*/_react.default.createElement(_test_models.TestModelAndPipelineCreationFlyout, {
    model: modelToTest,
    onClose: refreshList => {
      setModelToTest(null);
      if (refreshList) {
        fetchModelsData();
      }
    }
  }), dfaModelToTest === null ? null : /*#__PURE__*/_react.default.createElement(_test_dfa_models_flyout.TestDfaModelsFlyout, {
    model: dfaModelToTest,
    onClose: setDfaModelToTest.bind(null, null)
  }), modelToDeploy !== undefined ? /*#__PURE__*/_react.default.createElement(_ml_inference.AddInferencePipelineFlyout, {
    onClose: setModelToDeploy.bind(null, undefined),
    model: modelToDeploy
  }) : null, isAddModelFlyoutVisible ? /*#__PURE__*/_react.default.createElement(AddModelFlyout, {
    modelDownloads: items.filter(i => i.state === _mlTrainedModelsUtils.MODEL_STATE.NOT_DOWNLOADED),
    onClose: setIsAddModelFlyoutVisible.bind(null, false),
    onSubmit: modelId => {
      onModelDownloadRequest(modelId);
      setIsAddModelFlyoutVisible(false);
    }
  }) : null);
};
exports.ModelsList = ModelsList;