"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInferencePropertiesFromPipelineConfig = getInferencePropertiesFromPipelineConfig;
exports.isMlInferencePipelineInferenceConfig = isMlInferencePipelineInferenceConfig;
exports.isMlIngestInferenceProcessor = isMlIngestInferenceProcessor;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _inference_base = require("../test_models/models/inference_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INPUT_FIELD = 'inputField';
const ZERO_SHOT_CLASSIFICATION_PROPERTIES = ['labels', 'multi_label'];
const QUESTION_ANSWERING_PROPERTIES = ['question'];
const MODEL_INFERENCE_CONFIG_PROPERTIES = {
  [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING]: QUESTION_ANSWERING_PROPERTIES,
  [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION]: ZERO_SHOT_CLASSIFICATION_PROPERTIES
};

// Currently, estypes doesn't include pipeline processor types with the trained model processors

function isSupportedInferenceConfigPropertyType(arg) {
  return typeof arg === 'string' && Object.keys(MODEL_INFERENCE_CONFIG_PROPERTIES).includes(arg);
}
function isMlInferencePipelineInferenceConfig(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING]) || (0, _mlIsPopulatedObject.isPopulatedObject)(arg, [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION]);
}
function isMlIngestInferenceProcessor(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg) && arg.hasOwnProperty('inference_config') && ((0, _mlIsPopulatedObject.isPopulatedObject)(arg.inference_config, [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING]) || (0, _mlIsPopulatedObject.isPopulatedObject)(arg.inference_config, [_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION]));
}
function getInferencePropertiesFromPipelineConfig(type, pipelineConfig) {
  var _pipelineConfig$proce;
  const propertiesToReturn = {
    [INPUT_FIELD]: ''
  };
  (_pipelineConfig$proce = pipelineConfig.processors) === null || _pipelineConfig$proce === void 0 ? void 0 : _pipelineConfig$proce.forEach(processor => {
    const {
      inference
    } = processor;
    if (inference) {
      propertiesToReturn.inferenceObj = inference;
      // Get the input field
      if (inference.field_map) {
        propertiesToReturn.fieldMap = inference.field_map;
        for (const [key, value] of Object.entries(inference.field_map)) {
          if (value === _inference_base.DEFAULT_INPUT_FIELD) {
            propertiesToReturn[INPUT_FIELD] = key;
          }
        }
        if (propertiesToReturn[INPUT_FIELD] === '') {
          // If not found, set to the first field in the field map
          propertiesToReturn[INPUT_FIELD] = Object.keys(inference.field_map)[0];
        }
      }
      propertiesToReturn.inferenceConfig = inference.inference_config;
      // Get the properties associated with the type of model/task
      if (isMlInferencePipelineInferenceConfig(propertiesToReturn.inferenceConfig) && isSupportedInferenceConfigPropertyType(type)) {
        var _MODEL_INFERENCE_CONF;
        (_MODEL_INFERENCE_CONF = MODEL_INFERENCE_CONFIG_PROPERTIES[type]) === null || _MODEL_INFERENCE_CONF === void 0 ? void 0 : _MODEL_INFERENCE_CONF.forEach(property => {
          const configSettings = propertiesToReturn.inferenceConfig && propertiesToReturn.inferenceConfig[type];
          propertiesToReturn[property] = configSettings && configSettings.hasOwnProperty(property) ?
          // @ts-ignore
          configSettings[property] : undefined;
        });
      }
    }
  });
  return propertiesToReturn;
}