"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _wizard = require("./wizard");
var _step_types = require("../components/step_types");
var _general = require("../../common/job_creator/util/general");
var _job_creator = require("../../common/job_creator");
var _new_job = require("../../../../../../common/constants/new_job");
var _chart_loader = require("../../common/chart_loader");
var _map_loader = require("../../common/map_loader");
var _results_loader = require("../../common/results_loader");
var _job_validator = require("../../common/job_validator");
var _ml = require("../../../../contexts/ml");
var _kibana = require("../../../../contexts/kibana");
var _job_service = require("../../../../services/job_service");
var _new_job_capabilities_service = require("../../../../services/new_job_capabilities/new_job_capabilities_service");
var _ml_server_info = require("../../../../services/ml_server_info");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _page_header = require("../../../../components/page_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_WIDTH = 1200; // document.querySelector('.single-metric-job-container').width();
const BAR_TARGET = PAGE_WIDTH > 2000 ? 1000 : PAGE_WIDTH / 2;
const MAX_BARS = BAR_TARGET + BAR_TARGET / 100 * 100; // 100% larger than bar target

const Page = ({
  existingJobsAndGroups,
  jobType
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const dataSourceContext = (0, _ml.useDataSource)();
  const {
    services: {
      maps: mapsPlugin,
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const chartInterval = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const jobCreator = (0, _react.useMemo)(() => (0, _job_creator.jobCreatorFactory)(jobType)(dataSourceContext.selectedDataView, dataSourceContext.selectedSavedSearch, dataSourceContext.combinedQuery),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobType]);
  const jobValidator = (0, _react.useMemo)(() => new _job_validator.JobValidator(jobCreator), [jobCreator]);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    from,
    to
  } = (0, _mlDatePicker.getTimeFilterRange)(timefilter);
  jobCreator.setTimeRange(from, to);
  let firstWizardStep = jobType === _new_job.JOB_TYPE.ADVANCED ? _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED : _step_types.WIZARD_STEPS.TIME_RANGE;
  let autoSetTimeRange = _job_service.mlJobService.tempJobCloningObjects.autoSetTimeRange;
  _job_service.mlJobService.tempJobCloningObjects.autoSetTimeRange = false;
  if (_job_service.mlJobService.tempJobCloningObjects.job !== undefined && _job_service.mlJobService.tempJobCloningObjects.datafeed !== undefined) {
    // cloning a job
    const clonedJob = _job_service.mlJobService.tempJobCloningObjects.job;
    const clonedDatafeed = _job_service.mlJobService.cloneDatafeed(_job_service.mlJobService.tempJobCloningObjects.datafeed);
    initCategorizationSettings();
    jobCreator.cloneFromExistingJob(clonedJob, clonedDatafeed);

    // if we're not skipping the time range, this is a standard job clone, so wipe the jobId
    if (_job_service.mlJobService.tempJobCloningObjects.skipTimeRangeStep === false) {
      jobCreator.jobId = '';
    } else if (jobType !== _new_job.JOB_TYPE.ADVANCED) {
      firstWizardStep = _step_types.WIZARD_STEPS.PICK_FIELDS;
    }
    _job_service.mlJobService.tempJobCloningObjects.skipTimeRangeStep = false;
    _job_service.mlJobService.tempJobCloningObjects.job = undefined;
    _job_service.mlJobService.tempJobCloningObjects.datafeed = undefined;
    _job_service.mlJobService.tempJobCloningObjects.createdBy = undefined;
    if (_job_service.mlJobService.tempJobCloningObjects.start !== undefined && _job_service.mlJobService.tempJobCloningObjects.end !== undefined) {
      // auto select the start and end dates for the time range picker
      jobCreator.setTimeRange(_job_service.mlJobService.tempJobCloningObjects.start, _job_service.mlJobService.tempJobCloningObjects.end);
      _job_service.mlJobService.tempJobCloningObjects.start = undefined;
      _job_service.mlJobService.tempJobCloningObjects.end = undefined;
    } else {
      // if not start and end times are set and this is an advanced job,
      // auto set the time range based on the index
      autoSetTimeRange = autoSetTimeRange || (0, _job_creator.isAdvancedJobCreator)(jobCreator);
    }
    if (_job_service.mlJobService.tempJobCloningObjects.calendars) {
      jobCreator.calendars = _job_service.mlJobService.tempJobCloningObjects.calendars;
      _job_service.mlJobService.tempJobCloningObjects.calendars = undefined;
    }
  } else {
    // creating a new job
    jobCreator.bucketSpan = _new_job.DEFAULT_BUCKET_SPAN;
    if (jobCreator.type !== _new_job.JOB_TYPE.POPULATION && jobCreator.type !== _new_job.JOB_TYPE.ADVANCED && jobCreator.type !== _new_job.JOB_TYPE.CATEGORIZATION) {
      // for all other than population or advanced, use 10MB
      jobCreator.modelMemoryLimit = _new_job.DEFAULT_MODEL_MEMORY_LIMIT;
    }
    if (jobCreator.type === _new_job.JOB_TYPE.SINGLE_METRIC) {
      jobCreator.modelPlot = true;
      jobCreator.modelChangeAnnotations = true;
    }
    if (dataSourceContext.selectedSavedSearch !== null) {
      // Jobs created from saved searches cannot be cloned in the wizard as the
      // ML job config holds no reference to the saved search ID.
      jobCreator.createdBy = null;
    }

    // auto set the time range if creating a new advanced job
    autoSetTimeRange = (0, _job_creator.isAdvancedJobCreator)(jobCreator);
    initCategorizationSettings();
    if ((0, _job_creator.isCategorizationJobCreator)(jobCreator)) {
      const {
        catFields
      } = _new_job_capabilities_service.newJobCapsService;
      if (catFields.length === 1) {
        jobCreator.categorizationFieldName = catFields[0].name;
      }
    }
  }
  if (autoSetTimeRange) {
    // for advanced jobs, load the full time range start and end times
    // so they can be used for job validation and bucket span estimation
    jobCreator.autoSetTimeRange().catch(error => {
      const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.autoSetJobCreatorTimeRange.error', {
        defaultMessage: `Error retrieving beginning and end times of index`
      });
      displayErrorToast(error, title);
    });
  }
  function initCategorizationSettings() {
    if ((0, _job_creator.isCategorizationJobCreator)(jobCreator)) {
      // categorization job will always use a count agg, so give it
      // to the job creator now
      const count = _new_job_capabilities_service.newJobCapsService.getAggById('count');
      const highCount = _new_job_capabilities_service.newJobCapsService.getAggById('high_count');
      const rare = _new_job_capabilities_service.newJobCapsService.getAggById('rare');
      const eventRate = _new_job_capabilities_service.newJobCapsService.getFieldById(_mlAnomalyUtils.EVENT_RATE_FIELD_ID);
      jobCreator.setDefaultDetectorProperties(count, highCount, rare, eventRate);
      const {
        anomaly_detectors: anomalyDetectors
      } = (0, _ml_server_info.getNewJobDefaults)();
      jobCreator.categorizationAnalyzer = anomalyDetectors.categorization_analyzer;
    } else if ((0, _job_creator.isRareJobCreator)(jobCreator)) {
      const rare = _new_job_capabilities_service.newJobCapsService.getAggById('rare');
      const freqRare = _new_job_capabilities_service.newJobCapsService.getAggById('freq_rare');
      jobCreator.setDefaultDetectorProperties(rare, freqRare);
    } else if ((0, _job_creator.isGeoJobCreator)(jobCreator)) {
      const geo = _new_job_capabilities_service.newJobCapsService.getAggById('lat_long');
      jobCreator.setDefaultDetectorProperties(geo);
    }
  }
  chartInterval.setBarTarget(BAR_TARGET);
  chartInterval.setMaxBars(MAX_BARS);
  chartInterval.setInterval('auto');
  const chartLoader = (0, _react.useMemo)(() => new _chart_loader.ChartLoader(dataSourceContext.selectedDataView, jobCreator.query), [dataSourceContext.selectedDataView, jobCreator.query]);
  const mapLoader = (0, _react.useMemo)(() => new _map_loader.MapLoader(dataSourceContext.selectedDataView, jobCreator.query, mapsPlugin), [dataSourceContext.selectedDataView, jobCreator.query, mapsPlugin]);
  const resultsLoader = (0, _react.useMemo)(() => new _results_loader.ResultsLoader(jobCreator, chartInterval, chartLoader), [jobCreator, chartInterval, chartLoader]);
  (0, _react.useEffect)(() => {
    return () => {
      jobCreator.forceStopRefreshPolls();
    };
  });
  const jobCreatorTitle = (0, _general.getJobCreatorTitle)(jobCreator);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `mlPageJobWizardHeader-${jobCreator.type}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.page.createJob",
    defaultMessage: "Create job"
  }), ":", ' ', jobCreatorTitle)), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      backgroundColor: 'inherit'
    },
    "data-test-subj": `mlPageJobWizard ${jobType}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's'
  }, dataSourceContext.selectedDataView.isPersisted() ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.page.createJob.dataViewName",
    defaultMessage: "Using data view {dataViewName}",
    values: {
      dataViewName: jobCreator.indexPatternDisplayName
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.page.createJob.tempDataViewName",
    defaultMessage: "Using temporary data view {dataViewName}",
    values: {
      dataViewName: jobCreator.indexPatternDisplayName
    }
  })), /*#__PURE__*/_react.default.createElement(_wizard.Wizard, {
    jobCreator: jobCreator,
    chartLoader: chartLoader,
    mapLoader: mapLoader,
    resultsLoader: resultsLoader,
    chartInterval: chartInterval,
    jobValidator: jobValidator,
    existingJobsAndGroups: existingJobsAndGroups,
    firstWizardStep: firstWizardStep
  })));
};
exports.Page = Page;