"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../contexts/kibana");
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _job_service = require("../../../../../services/job_service");
var _json_editor_flyout = require("../common/json_editor_flyout");
var _job_creator = require("../../../common/job_creator");
var _job_details = require("./components/job_details");
var _datafeed_details = require("./components/datafeed_details");
var _detector_chart = require("./components/detector_chart");
var _job_progress = require("./components/job_progress");
var _post_save_options = require("./components/post_save_options");
var _start_datafeed_switch = require("./components/start_datafeed_switch");
var _jobs_awaiting_node_warning = require("../../../../../components/jobs_awaiting_node_warning");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _general = require("../../../common/job_creator/util/general");
var _common = require("./components/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    services: {
      notifications,
      http: {
        basePath
      }
    }
  } = (0, _kibana.useMlKibana)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated,
    resultsLoader
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [progress, setProgress] = (0, _react.useState)(resultsLoader.progress);
  const [creatingJob, setCreatingJob] = (0, _react.useState)(false);
  const [isValid, setIsValid] = (0, _react.useState)(jobValidator.validationSummary.basic);
  const [jobRunner, setJobRunner] = (0, _react.useState)(null);
  const [startDatafeed, setStartDatafeed] = (0, _react.useState)(true);
  const [showJobAssignWarning, setShowJobAssignWarning] = (0, _react.useState)(false);
  const isAdvanced = (0, _job_creator.isAdvancedJobCreator)(jobCreator);
  const jsonEditorMode = isAdvanced ? _json_editor_flyout.EDITOR_MODE.EDITABLE : _json_editor_flyout.EDITOR_MODE.READONLY;
  (0, _react.useEffect)(() => {
    jobCreator.subscribeToProgress(setProgress);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    let s = null;
    if (jobRunner !== null) {
      s = jobRunner.subscribeToJobAssignment(assigned => setShowJobAssignWarning(!assigned));
    }
    return () => {
      if (s !== null) {
        var _s;
        (_s = s) === null || _s === void 0 ? void 0 : _s.unsubscribe();
      }
    };
  }, [jobRunner]);
  async function start() {
    setCreatingJob(true);
    if (isAdvanced) {
      await createAdvancedJob();
    } else if (startDatafeed === true) {
      await createAndStartJob();
    } else {
      await createAdvancedJob(false);
    }
  }
  async function createAndStartJob() {
    try {
      const jr = await jobCreator.createAndStartJob();
      setJobRunner(jr);
    } catch (error) {
      handleJobCreationError(error);
    }
  }
  async function createAdvancedJob(showStartModal = true) {
    try {
      await jobCreator.createJob();
      await jobCreator.createDatafeed();
      (0, _general.advancedStartDatafeed)(showStartModal ? jobCreator : null, navigateToPath);
    } catch (error) {
      handleJobCreationError(error);
    }
  }
  function handleJobCreationError(error) {
    const {
      displayErrorToast
    } = (0, _toast_notification_service.toastNotificationServiceProvider)(notifications.toasts);
    displayErrorToast(error, _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.createJobError', {
      defaultMessage: `Job creation error`
    }));
    setCreatingJob(false);
  }
  function viewResults() {
    const url = _job_service.mlJobService.createResultsUrl([jobCreator.jobId], jobCreator.start, jobCreator.end, (0, _job_creator.isSingleMetricJobCreator)(jobCreator) === true ? 'timeseriesexplorer' : 'explorer');
    navigateToPath(`${basePath.get()}/app/ml/${url}`);
  }
  function clickResetJob() {
    (0, _general.resetJob)(jobCreator, navigateToPath);
  }
  const convertToAdvanced = () => {
    (0, _general.convertToAdvancedJob)(jobCreator, navigateToPath);
  };
  (0, _react.useEffect)(() => {
    setIsValid(jobValidator.validationSummary.basic);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isAdvanced && /*#__PURE__*/_react.default.createElement(_common.JobSectionTitle, null), /*#__PURE__*/_react.default.createElement(_detector_chart.DetectorChart, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_job_progress.JobProgress, {
    progress: progress
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, null), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_start_datafeed_switch.StartDatafeedSwitch, {
    startDatafeed: startDatafeed,
    setStartDatafeed: setStartDatafeed,
    disabled: creatingJob
  }), isAdvanced && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_common.DatafeedSectionTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_datafeed_details.DatafeedDetails, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), showJobAssignWarning && /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.NewJobAwaitingNodeWarning, {
    jobType: "anomaly-detector"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, progress < 100 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_wizard_nav.PreviousButton, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.VALIDATION),
    previousActive: creatingJob === false && isValid === true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: start,
    isDisabled: creatingJob === true || isValid === false,
    "data-test-subj": "mlJobWizardButtonCreateJob",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.createJobButton",
    defaultMessage: "Create job"
  })))), creatingJob === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: progress > 0,
    jobEditorMode: jsonEditorMode,
    datafeedEditorMode: jsonEditorMode
  })), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: convertToAdvanced,
    "data-test-subj": "mlJobWizardButtonConvertToAdvancedJob"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.convertToAdvancedButton",
    defaultMessage: "Convert to advanced job"
  })))), progress > 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: viewResults,
    "data-test-subj": "mlJobWizardButtonViewResults"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.viewResultsButton",
    defaultMessage: "View results"
  })))), progress === 100 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: clickResetJob,
    "data-test-subj": "mlJobWizardButtonResetJob"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.summaryStep.resetJobButton",
    defaultMessage: "Reset job"
  }))), /*#__PURE__*/_react.default.createElement(_post_save_options.PostSaveOptions, {
    jobRunner: jobRunner
  })))));
};
exports.SummaryStep = SummaryStep;