"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultChartSettings = void 0;
exports.getChartSettings = getChartSettings;
exports.seriesStyle = void 0;
exports.useChartColors = useChartColors;
var _kibana = require("../../../../../../contexts/kibana");
var _job_creator = require("../../../../common/job_creator");
var _get_time_buckets_from_cache = require("../../../../../../util/get_time_buckets_from_cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useChartColors() {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  return {
    LINE_COLOR: euiTheme.euiColorPrimary,
    MODEL_COLOR: euiTheme.euiColorPrimary,
    EVENT_RATE_COLOR: euiTheme.euiColorPrimary,
    EVENT_RATE_COLOR_WITH_ANOMALIES: euiTheme.euiColorLightShade
  };
}
const defaultChartSettings = exports.defaultChartSettings = {
  width: '100%',
  height: '300px',
  cols: 1,
  intervalMs: 0
};
const seriesStyle = exports.seriesStyle = {
  line: {
    strokeWidth: 2,
    visible: true,
    opacity: 1
  },
  border: {
    visible: false,
    strokeWidth: 0
  },
  point: {
    visible: false,
    radius: 2,
    strokeWidth: 4,
    opacity: 0.5
  },
  area: {
    opacity: 0.25,
    visible: false
  }
};
function getChartSettings(jobCreator, chartInterval) {
  const cs = {
    ...defaultChartSettings,
    intervalMs: chartInterval.getInterval().asMilliseconds()
  };
  if ((0, _job_creator.isPopulationJobCreator)(jobCreator)) {
    // for population charts, use a larger interval based on
    // the calculation from TimeBuckets, but without the
    // bar target and max bars which have been set for the
    // general chartInterval
    const interval = (0, _get_time_buckets_from_cache.getTimeBucketsFromCache)();
    interval.setInterval('auto');
    interval.setBounds(chartInterval.getBounds());
    cs.intervalMs = interval.getInterval().asMilliseconds();
  }
  if (cs.intervalMs < jobCreator.bucketSpanMs) {
    // don't allow the chart interval to be smaller than the bucket span
    cs.intervalMs = jobCreator.bucketSpanMs;
  }
  if ((0, _job_creator.isMultiMetricJobCreator)(jobCreator) || (0, _job_creator.isPopulationJobCreator)(jobCreator)) {
    if (jobCreator.aggFieldPairs.length > 2 && (0, _job_creator.isMultiMetricJobCreator)(jobCreator)) {
      cs.cols = 3;
      cs.height = '150px';
      cs.intervalMs = cs.intervalMs * 3;
    } else if (jobCreator.aggFieldPairs.length > 1) {
      cs.cols = 2;
      cs.height = '200px';
      cs.intervalMs = cs.intervalMs * 2;
    }
  }
  return cs;
}