"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _quick_create_job = require("./quick_create_job");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(deps, categorizationTypeRisonString, dataViewIdRisonString, fieldRisonString, partitionFieldRisonString, stopOnWarnRisonString, fromRisonString, toRisonString, queryRisonString) {
  const {
    mlApiServices,
    timeFilter,
    kibanaConfig,
    dashboardService,
    data
  } = deps;
  const query = (0, _new_job_utils.getRisonValue)(queryRisonString, (0, _new_job_utils.getDefaultDatafeedQuery)());
  const from = (0, _new_job_utils.getRisonValue)(fromRisonString, '');
  const to = (0, _new_job_utils.getRisonValue)(toRisonString, '');
  const categorizationType = (0, _new_job_utils.getRisonValue)(categorizationTypeRisonString, _quick_create_job.CATEGORIZATION_TYPE.COUNT);
  const dataViewId = (0, _new_job_utils.getRisonValue)(dataViewIdRisonString, '');
  const field = (0, _new_job_utils.getRisonValue)(fieldRisonString, '');
  const partitionField = partitionFieldRisonString === null ? '' : (0, _new_job_utils.getRisonValue)(partitionFieldRisonString, '');
  const stopOnWarn = (0, _new_job_utils.getRisonValue)(stopOnWarnRisonString, false);
  const jobCreator = new _quick_create_job.QuickCategorizationJobCreator(data.dataViews, kibanaConfig, timeFilter, dashboardService, data, mlApiServices);
  await jobCreator.createAndStashADJob(categorizationType, dataViewId, field, partitionField, stopOnWarn, from, to, query);
}