"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiMetricJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MultiMetricJobCreator extends _job_creator.JobCreator {
  constructor(indexPattern, savedSearch, query) {
    super(indexPattern, savedSearch, query);
    // a multi-metric job has one optional overall partition field
    // which is the same for all detectors.
    (0, _defineProperty2.default)(this, "_splitField", null);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.MULTI_METRIC);
    this.createdBy = _new_job.CREATED_BY_LABEL.MULTI_METRIC;
    this._wizardInitialized$.next(true);
  }

  // set the split field, applying it to each detector
  setSplitField(field) {
    this._splitField = field;
    if (this._splitField === null) {
      this.removeSplitField();
    } else {
      for (let i = 0; i < this._detectors.length; i++) {
        this._detectors[i].partition_field_name = this._splitField.id;
      }
    }
  }
  removeSplitField() {
    this._detectors.forEach(d => {
      delete d.partition_field_name;
    });
  }
  get splitField() {
    return this._splitField;
  }
  addDetector(agg, field) {
    const dtr = this._createDetector(agg, field);
    this._addDetector(dtr, agg, field);
  }
  editDetector(agg, field, index) {
    const dtr = this._createDetector(agg, field);
    this._editDetector(dtr, agg, field, index);
  }

  // create a new detector object, applying the overall split field
  _createDetector(agg, field) {
    const dtr = (0, _default_configs.createBasicDetector)(agg, field);
    if (this._splitField !== null) {
      dtr.partition_field_name = this._splitField.id;
    }
    return dtr;
  }
  removeDetector(index) {
    this._removeDetector(index);
  }
  get aggFieldPairs() {
    return this.detectors.map((d, i) => ({
      field: this._fields[i],
      agg: this._aggs[i]
    }));
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    this.createdBy = _new_job.CREATED_BY_LABEL.MULTI_METRIC;
    this._sparseData = (0, _general.isSparseDataJob)(job, datafeed);
    const detectors = (0, _general.getRichDetectors)(job, datafeed, this.additionalFields, false);
    if (datafeed.aggregations !== undefined) {
      // if we've converting from a single metric job,
      // delete the aggregations.
      delete datafeed.aggregations;
      delete job.analysis_config.summary_count_field_name;
    }
    this.removeAllDetectors();
    detectors.forEach((d, i) => {
      const dtr = detectors[i];
      if (dtr.agg !== null && dtr.field !== null) {
        this.addDetector(dtr.agg, dtr.field);
      }
    });
    if (detectors.length) {
      if (detectors[0].partitionField !== null) {
        this.setSplitField(detectors[0].partitionField);
      }
    }
  }
}
exports.MultiMetricJobCreator = MultiMetricJobCreator;