"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForecastsTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _states = require("../../../../../../../common/constants/states");
var _recently_accessed = require("../../../../../util/recently_accessed");
var _forecast_service = require("../../../../../services/forecast_service");
var _job_utils = require("../../../../../../../common/util/job_utils");
var _locator = require("../../../../../../../common/constants/locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_FORECASTS = 500;

/**
 * Table component for rendering the lists of forecasts run on an ML job.
 */
class ForecastsTable extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      isLoading: props.job.data_counts.processed_record_count !== 0,
      forecasts: []
    };
    this.mlForecastService;
  }

  /**
   * Access ML services in react context.
   */

  componentDidMount() {
    this.mlForecastService = (0, _forecast_service.forecastServiceFactory)(this.context.services.mlServices.mlApiServices);
    const dataCounts = this.props.job.data_counts;
    if (dataCounts.processed_record_count > 0) {
      // Get the list of all the forecasts with results at or later than the specified 'from' time.
      this.mlForecastService.getForecastsSummary(this.props.job, null, dataCounts.earliest_record_timestamp, MAX_FORECASTS).then(resp => {
        this.setState({
          isLoading: false,
          forecasts: resp.forecasts
        });
      }).catch(resp => {
        console.log('Error loading list of forecasts for jobs list:', resp);
        this.setState({
          isLoading: false,
          errorMessage: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.loadingErrorMessage', {
            defaultMessage: 'Error loading the list of forecasts run on this job'
          }),
          forecasts: []
        });
      });
    }
  }
  async openSingleMetricView(forecast) {
    const {
      services: {
        application: {
          navigateToUrl
        },
        share
      }
    } = this.context;

    // Creates the link to the Single Metric Viewer.
    // Set the total time range from the start of the job data to the end of the forecast,
    const dataCounts = this.props.job.data_counts;
    const jobEarliest = dataCounts.earliest_record_timestamp;
    const resultLatest = (0, _job_utils.getLatestDataOrBucketTimestamp)(dataCounts.latest_record_timestamp, dataCounts.latest_bucket_timestamp);
    const from = new Date(dataCounts.earliest_record_timestamp).toISOString();
    const to = forecast !== undefined ? new Date(forecast.forecast_end_timestamp).toISOString() : new Date(resultLatest).toISOString();
    let mlTimeSeriesExplorer = {};
    if (forecast !== undefined) {
      // Set the zoom to show duration before the forecast equal to the length of the forecast.
      const forecastDurationMs = forecast.forecast_end_timestamp - forecast.forecast_start_timestamp;
      const zoomFrom = Math.max(forecast.forecast_start_timestamp - forecastDurationMs, jobEarliest);
      mlTimeSeriesExplorer = {
        forecastId: forecast.forecast_id,
        zoom: {
          from: new Date(zoomFrom).toISOString(),
          to: new Date(forecast.forecast_end_timestamp).toISOString()
        }
      };
    }
    const mlLocator = share.url.locators.get(_locator.ML_APP_LOCATOR);
    const singleMetricViewerForecastLink = await mlLocator.getUrl({
      page: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
      pageState: {
        timeRange: {
          from,
          to,
          mode: 'absolute'
        },
        refreshInterval: {
          display: 'Off',
          pause: true,
          value: 0
        },
        jobIds: [this.props.job.job_id],
        query: {
          query_string: {
            analyze_wildcard: true,
            query: '*'
          }
        },
        ...mlTimeSeriesExplorer
      }
    }, {
      absolute: true
    });
    (0, _recently_accessed.addItemToRecentlyAccessed)('timeseriesexplorer', this.props.job.job_id, singleMetricViewerForecastLink);
    await navigateToUrl(singleMetricViewerForecastLink);
  }
  render() {
    if (this.state.isLoading === true) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      })));
    }
    if (this.state.errorMessage !== undefined) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: this.state.errorMessage,
        color: "danger",
        iconType: "cross"
      });
    }
    const forecasts = this.state.forecasts;
    if (forecasts.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsTitle",
          defaultMessage: "No forecasts have been run for this job"
        }),
        iconType: "iInCircle",
        role: "alert"
      }, (0, _job_utils.isTimeSeriesViewJob)(this.props.job) && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsDescription",
        defaultMessage: "To run a forecast, open the {singleMetricViewerLink}",
        values: {
          singleMetricViewerLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: () => this.openSingleMetricView()
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.jobsList.jobDetails.forecastsTable.noForecastsDescription.linkText",
            defaultMessage: "Single Metric Viewer"
          }))
        }
      })));
    }
    const columns = [{
      field: 'forecast_create_timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.createdLabel', {
        defaultMessage: 'Created'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      textOnly: true,
      sortable: true,
      scope: 'row'
    }, {
      field: 'forecast_start_timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.fromLabel', {
        defaultMessage: 'From'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      textOnly: true,
      sortable: true
    }, {
      field: 'forecast_end_timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.toLabel', {
        defaultMessage: 'To'
      }),
      dataType: 'date',
      render: _mlDateUtils.timeFormatter,
      textOnly: true,
      sortable: true
    }, {
      field: 'forecast_status',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.statusLabel', {
        defaultMessage: 'Status'
      }),
      sortable: true
    }, {
      field: 'forecast_memory_bytes',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.memorySizeLabel', {
        defaultMessage: 'Memory size'
      }),
      render: bytes => (0, _eui.formatNumber)(bytes, '0b'),
      sortable: true
    }, {
      field: 'processing_time_ms',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.processingTimeLabel', {
        defaultMessage: 'Processing time'
      }),
      render: ms => _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.msTimeUnitLabel', {
        defaultMessage: '{ms} ms',
        values: {
          ms
        }
      }),
      sortable: true
    }, {
      field: 'forecast_expiry_timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.expiresLabel', {
        defaultMessage: 'Expires'
      }),
      render: _mlDateUtils.timeFormatter,
      textOnly: true,
      sortable: true
    }, {
      field: 'forecast_messages',
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.messagesLabel', {
        defaultMessage: 'Messages'
      }),
      sortable: false,
      render: messages => {
        return /*#__PURE__*/_react.default.createElement("div", null, messages.map((message, index) => {
          return /*#__PURE__*/_react.default.createElement("p", {
            key: index
          }, message);
        }));
      },
      textOnly: true
    }, {
      name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.viewLabel', {
        defaultMessage: 'View'
      }),
      width: '60px',
      render: forecast => {
        const viewForecastAriaLabel = _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.forecastsTable.viewAriaLabel', {
          defaultMessage: 'View forecast created at {createdDate}',
          values: {
            createdDate: (0, _mlDateUtils.timeFormatter)(forecast.forecast_create_timestamp)
          }
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          onClick: () => this.openSingleMetricView(forecast),
          isDisabled: this.props.job.blocked !== undefined || forecast.forecast_status !== _states.FORECAST_REQUEST_STATE.FINISHED,
          iconType: "visLine",
          "aria-label": viewForecastAriaLabel,
          "data-test-subj": "mlJobListForecastTabOpenSingleMetricViewButton"
        });
      }
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      "data-test-subj": "mlJobListForecastTable",
      compressed: true,
      items: forecasts,
      columns: columns,
      pagination: {
        pageSizeOptions: [5, 10, 25]
      },
      sorting: true
    });
  }
}
exports.ForecastsTable = ForecastsTable;
(0, _defineProperty2.default)(ForecastsTable, "contextType", _public.context);
ForecastsTable.propTypes = {
  job: _propTypes.default.object.isRequired
};