"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.explorerServiceFactory = exports.explorerAction$ = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _actions = require("./actions");
var _explorer_constants = require("./explorer_constants");
var _reducers = require("./reducers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Service for firing and registering for events across the different
 * components in the Explorer dashboard.
 */

const explorerAction$ = exports.explorerAction$ = new _rxjs.Subject();
const explorerFilteredAction$ = explorerAction$.pipe(
// consider observables as side-effects
(0, _rxjs.flatMap)(action => (0, _rxjs.isObservable)(action) ? action : (0, _rxjs.from)([action])), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual));

// applies action and returns state
const explorerState$ = explorerFilteredAction$.pipe((0, _rxjs.scan)(_reducers.explorerReducer, (0, _reducers.getExplorerDefaultState)()),
// share the last emitted value among new subscribers
(0, _rxjs.shareReplay)(1));
const setExplorerDataActionCreator = payload => ({
  type: _explorer_constants.EXPLORER_ACTION.SET_EXPLORER_DATA,
  payload
});

// Export observable state and action dispatchers as service
const explorerServiceFactory = mlFieldFormatService => ({
  state$: explorerState$,
  clearExplorerData: () => {
    explorerAction$.next({
      type: _explorer_constants.EXPLORER_ACTION.CLEAR_EXPLORER_DATA
    });
  },
  clearInfluencerFilterSettings: () => {
    explorerAction$.next({
      type: _explorer_constants.EXPLORER_ACTION.CLEAR_INFLUENCER_FILTER_SETTINGS
    });
  },
  clearJobs: () => {
    explorerAction$.next({
      type: _explorer_constants.EXPLORER_ACTION.CLEAR_JOBS
    });
  },
  updateJobSelection: selectedJobIds => {
    explorerAction$.next((0, _actions.jobSelectionActionCreator)(mlFieldFormatService, selectedJobIds));
  },
  setExplorerData: payload => {
    explorerAction$.next(setExplorerDataActionCreator(payload));
  },
  setChartsDataLoading: () => {
    explorerAction$.next({
      type: _explorer_constants.EXPLORER_ACTION.SET_CHARTS_DATA_LOADING
    });
  }
});
exports.explorerServiceFactory = explorerServiceFactory;