"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.drawCursor = drawCursor;
var _d = _interopRequireDefault(require("d3"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function drawCursor(cursor, rootNode, chartId, config, chartScales, chartTheme) {
  var _chartTheme$crosshair, _chartTheme$crosshair2, _crosshairLine$dash$j, _crosshairLine$dash;
  if (!chartScales) return;
  const {
    lineChartXScale,
    margin: updatedMargin
  } = chartScales;
  const element = rootNode;
  const chartElement = _d.default.select(element).select('#ml-explorer-chart-svg' + chartId);
  if (!chartElement || !lineChartXScale) return;
  chartElement.select('.ml-anomaly-chart-cursor-line').remove();
  const crosshairLine = (_chartTheme$crosshair = chartTheme === null || chartTheme === void 0 ? void 0 : (_chartTheme$crosshair2 = chartTheme.crosshair) === null || _chartTheme$crosshair2 === void 0 ? void 0 : _chartTheme$crosshair2.line) !== null && _chartTheme$crosshair !== void 0 ? _chartTheme$crosshair : {
    visible: true,
    stroke: '#69707D',
    strokeWidth: 1,
    dash: [4, 4]
  };
  const cursorData = cursor && cursor.type === 'Over' && cursor.x !== null && cursor.x >= config.plotEarliest && cursor.x <= config.plotLatest ? [cursor.x] : [];
  const cursorMouseLine = chartElement.append('g').attr('class', 'ml-anomaly-chart-cursor').selectAll('.ml-anomaly-chart-cursor-line').data(cursorData);

  // @ts-expect-error d3 types are not up to date
  cursorMouseLine.enter().append('path').attr('class', 'ml-anomaly-chart-cursor-line').attr('d', ts => {
    const xPosition = lineChartXScale(ts);
    return `M${xPosition},${_constants.CHART_HEIGHT} ${xPosition},0`;
  })
  // Use elastic chart's cursor line style if possible
  .style('stroke', crosshairLine.stroke).style('stroke-width', `${crosshairLine.strokeWidth}px`).style('stroke-dasharray', (_crosshairLine$dash$j = (_crosshairLine$dash = crosshairLine.dash) === null || _crosshairLine$dash === void 0 ? void 0 : _crosshairLine$dash.join(',')) !== null && _crosshairLine$dash$j !== void 0 ? _crosshairLine$dash$j : '4,4').attr('transform', 'translate(' + updatedMargin.left + ',' + updatedMargin.top + ')');
  cursorMouseLine.exit().remove();
}