"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMLAnomaliesTypicalLayer = exports.getMLAnomaliesActualLayer = void 0;
var _common = require("@kbn/maps-plugin/common");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEATURE = 'Feature';
const POINT = 'Point';
function getAnomalyFeatures(anomalies, type) {
  const anomalyFeatures = [];
  for (let i = 0; i < anomalies.length; i++) {
    var _anomaly$causes$;
    const anomaly = anomalies[i];
    const geoResults = anomaly.geo_results || (anomaly === null || anomaly === void 0 ? void 0 : anomaly.causes) && (anomaly === null || anomaly === void 0 ? void 0 : (_anomaly$causes$ = anomaly.causes[0]) === null || _anomaly$causes$ === void 0 ? void 0 : _anomaly$causes$.geo_results);
    const coordinateStr = geoResults && geoResults[type];
    if (coordinateStr !== undefined) {
      // Must reverse coordinates here. Map expects [lon, lat] - anomalies are stored as [lat, lon] for lat_lon jobs
      const coordinates = coordinateStr.split(',').map(point => Number(point)).reverse();
      anomalyFeatures.push({
        type: FEATURE,
        geometry: {
          type: POINT,
          coordinates
        },
        properties: {
          record_score: Math.floor(anomaly.record_score),
          [type]: coordinates.map(point => Number(point.toFixed(2)))
        }
      });
    }
  }
  return anomalyFeatures;
}
const getMLAnomaliesTypicalLayer = anomalies => {
  return {
    id: 'anomalies_typical_layer',
    label: 'Typical',
    sourceDescriptor: {
      id: 'b7486535-171b-4d3b-bb2e-33c1a0a2854e',
      type: 'GEOJSON_FILE',
      __featureCollection: {
        features: getAnomalyFeatures(anomalies, 'typical_point'),
        type: 'FeatureCollection'
      }
    },
    visible: true,
    style: {
      type: 'VECTOR',
      properties: {
        fillColor: {
          type: 'STATIC',
          options: {
            color: '#98A2B2'
          }
        },
        lineColor: {
          type: 'STATIC',
          options: {
            color: '#fff'
          }
        },
        lineWidth: {
          type: 'STATIC',
          options: {
            size: 2
          }
        },
        iconSize: {
          type: 'STATIC',
          options: {
            size: 6
          }
        }
      }
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
};
exports.getMLAnomaliesTypicalLayer = getMLAnomaliesTypicalLayer;
const getMLAnomaliesActualLayer = anomalies => {
  return {
    id: 'anomalies_actual_layer',
    label: 'Actual',
    sourceDescriptor: {
      id: 'b7486535-171b-4d3b-bb2e-33c1a0a2854d',
      type: 'GEOJSON_FILE',
      __fields: [{
        name: 'record_score',
        type: 'number'
      }],
      __featureCollection: {
        features: getAnomalyFeatures(anomalies, 'actual_point'),
        type: 'FeatureCollection'
      }
    },
    visible: true,
    style: {
      type: 'VECTOR',
      properties: {
        fillColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            customColorRamp: _mlAnomalyUtils.ML_SEVERITY_COLOR_RAMP,
            field: {
              name: 'record_score',
              origin: _common.FIELD_ORIGIN.SOURCE
            },
            useCustomColorRamp: true
          }
        },
        lineColor: {
          type: 'STATIC',
          options: {
            color: '#fff'
          }
        },
        lineWidth: {
          type: 'STATIC',
          options: {
            size: 2
          }
        },
        iconSize: {
          type: 'STATIC',
          options: {
            size: 6
          }
        }
      }
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
};
exports.getMLAnomaliesActualLayer = getMLAnomaliesActualLayer;